<?php

namespace App\Models\Page;

use App\Models\Blog;
use App\Models\Events\Event;
use App\Models\News\News;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    use HasFactory;

    protected $fillable = [
    	'blog_id', 'news_id', 'event_id', 'name', 'email', 'message'
    ];

    public function blog(){
    	return $this->belongsTo(Blog::class, 'blog_id');
    }

    public function news(){
    	return $this->belongsTo(News::class, 'news_id');
    }

    public function event(){
    	return $this->belongsTo(Event::class, 'event_id');
    }
}
