@extends('layouts.front.app')
@section('meta')
    <title>Engineering Design and Drafting Service | {{ env('APP_NAME') }}</title>
    <meta name="description" content="Providing high-quality workforce and hosted services to Quanta Operating units" />

@stop
@section('css')
    <style>
        .widget__links-lis li a.border-bottom {
            cursor: text;
        }
    </style>
@endsection
@section('content')
    <div class="primary-content position-relative">

        <section class="page-header"
            style="background-position:center; background-size: cover; background-image: url({{ asset('/images/backgrounds/eng-banner.jpg') }});">

            <div class="container">
                <div class="offset-md-3 page-header__inner">
                    {{-- <ul class="thm-breadcrumb list-unstyled">
                    <li><a href="index.html">Home</a></li>
                    <li><span>/</span></li>
                    <li>services</li>
                </ul> --}}
                </div>
            </div>
        </section>
        <section class="services-one services-page">
            <div class="container">
                <div class="row">
                    <div class="col offset-md-3">
                        <div class="section-title text-start">
                            <p class="fw-bold" style="color:#000000; font-size:18px;">Quanta Philippines is here to support
                                and assist you in any stage of your Engineering design and drafting requirements.
                            </p>
                        </div>
                        <h2 class="section-title__title text-start mb-5">Engineering Design and Drafting</h2>
                        <div class="row">
                            <div class="col-xl-6 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/telecom 2.webp') }}" alt="">
                                        <div class="services-one__icon">
                                            <span class="icon-industrial"></span>
                                        </div>
                                    </div>
                                    <div class="services-one__content">
                                        <h3 class="services-one__title"><a>Telecommunication Engineering</a>
                                        </h3>
                                        <p class="services-one__text">Fibre optic cable routing in outside plant from small
                                            to large communities for green field and brown.</p>
                                        <ul class="widget__links-lis list-unstyled">
                                            <li> <a class="border-bottom" id="ftth" role="button">Fiber-To-The-Home
                                                    (FTTH) </a> </li>
                                            <li> <a class="border-bottom" id="permitting" role="button">Permitting</a>
                                            </li>
                                            <li> <a class="border-bottom" id="bs" role="button">Base Mapping</a>
                                            </li>
                                            <li> <a class="border-bottom" id="layout" role="button">Layout of Strand,
                                                    Coax and Fibel Cable</a> </li>
                                            <li> <a class="border-bottom" id="gps" role="button">GPS Points</a> </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6 wow fadeInDown animated" data-wow-duration="1500ms"
                                data-wow-delay="100ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 100ms; animation-name: fadeInDown;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/piping and instru 2.webp') }}" alt="">
                                        <div class="services-one__icon">
                                            <span class="icon-petroleum"></span>
                                        </div>
                                    </div>
                                    <div class="services-one__content">
                                        <h3 class="services-one__title"><a>Mechanical / Piping
                                                Engineering</a>
                                        </h3>
                                        <p class="services-one__text">Project development, pipeline route selection and
                                            planning, design of oil and gas pipelines and other facilities, general drafting
                                            works in 2D and 3D model.</p>
                                        <ul class="widget__links-lis list-unstyled">
                                            <li> <a class="border-bottom" id="oilGas" role="button">Oil and Gas</a>
                                            </li>
                                            <li> <a class="border-bottom" id="pc" role="button">Petrochemical /
                                                    Chemical </a> </li>
                                            <li> <a class="border-bottom" id="rp" role="button">Refinery Plant </a>
                                            </li>
                                            <li> <a class="border-bottom" id="cs" role="button">Compressor Stations
                                                </a> </li>
                                            <li> <a class="border-bottom" id="isf" role="button">Industrial / Storage
                                                    Facilities </a> </li>
                                            <li> <a class="border-bottom" id="renewable" role="button">Renewable </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6 wow fadeInRight animated" data-wow-duration="1500ms"
                                data-wow-delay="200ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 200ms; animation-name: fadeInRight;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/eletrical 1.webp') }}" alt="">
                                        <div class="services-one__icon">
                                            <span class="icon-engineering"></span>
                                        </div>
                                    </div>
                                    <div class="services-one__content">
                                        <h3 class="services-one__title"><a>Electrical / Instrumentation</a>
                                        </h3>
                                        <p class="services-one__text">Drawing preparation of key one-line models, schematic
                                            diagrams, termination box and panel, cable tray/conduit routing, schedule of
                                            load, cable/wire sizing and creation of BOM.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 col-lg-6 wow fadeInRight animate" data-wow-duration="1500ms"
                                data-wow-delay="200ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 200ms; animation-name: fadeInRight;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/solar 1.webp') }}" alt="">
                                        <div class="services-one__icon">
                                            <span class="icon-engineering"></span>
                                        </div>
                                    </div>
                                    <div class="services-one__content">
                                        <h3 class="services-one__title"><a>Solar Design</a></h3>
                                        <p class="services-one__text">Process of designing of solar power system, grid tie
                                            and off-grid configuration, evaluation of property for solar PV system, and
                                            calculation of ROI.</p>

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6 col-lg-6 wow fadeInRight animate" data-wow-duration="1500ms"
                                data-wow-delay="200ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 200ms; animation-name: fadeInRight;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/solar-panels-plant-engineer-reading-paperwork-learn-how-harness-sun-power.jpg') }}"
                                            alt="">
                                        <div class="services-one__icon">
                                            <span class="icon-engineering"></span>
                                        </div>
                                    </div>
                                    <div class="services-one__content">
                                        <h3 class="services-one__title"><a>CPP Capabilities in Engineering Design and
                                                Drafting Services</a></h3>
                                        <p class="services-one__text">This service focuses on a range of technical and
                                            analytical tasks to support clients in the energy sector, particularly in the
                                            growing field of renewable energy. The core of this offering is a team of
                                            professionals who combine engineering principles with sophisticated software to
                                            create detailed and precise designs.</p>

                                    </div>
                                </div>
                            </div>
                        </div>


                        <h2 class="section-title__title text-start mb-5">Services Licenses:</h2>
                        <div class="row">
                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 1.png') }}" alt="">

                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 2.png') }}" alt="">

                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 3.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 4.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 5.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 6.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 7.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 8.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 9.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 10.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 11.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 12.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 20.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 13.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 14.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 15.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 16.png') }}" alt="">

                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 17.png') }}" alt="">

                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 wow fadeInLeft animated" data-wow-duration="1500ms"
                                data-wow-delay="0ms"
                                style="visibility: visible; animation-duration: 1500ms; animation-delay: 0ms; animation-name: fadeInLeft;">

                                <div class="services-one__single">
                                    <div class="services-one__img">
                                        <img src="{{ asset('/images/engineer/engr cred 18.png') }}" alt="">

                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <div class="modal fade" id="modal" tabindex="-1" aria-labelledby="modal" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content rounded-0">
                <div class="modal-header border-0">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="content">

                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    <script>
        $('.modal-btn').click(function() {
            // alert()
            // console.log($(this))
            // $("#title").text($(this).data( "title" ))
            $("#content").html($(this).data("content"))
            // $("#img").attr('src', 'uploads/trusted-providers/'+ $(this).data( "img" ) )
        });
    </script>
@endsection
