<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="author" content="Serbilis.ph">
    <title>{{ ucfirst(Auth::user()->role) }} | {{ env('APP_NAME') }}</title>
    <link rel="apple-touch-icon" href="{{ asset('images/favicon.ico') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('images/favicon.ico') }}">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600" rel="stylesheet">

    {{-- datepicker --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">

    {{-- sweet alert cdn --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.4/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.4/dist/sweetalert2.all.min.js"></script>

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ asset('css/admin.min.css') }}">
    {{-- <link href=" {{ asset('css/qr_code.min.css') }}" rel="stylesheet"> --}}
    <!-- END: Vendor CSS-->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    @yield('meta')

    <!-- END: Custom CSS-->
    <style>
        .datepicker td,
        th {
            text-align: center;
            padding: 8px 12px;
            font-size: 14px;
        }
    </style>
</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern 2-columns  navbar-floating footer-static  " data-open="click" data-menu="vertical-menu-modern" data-col="2-columns">

    <!-- BEGIN: Header-->
    <nav class="header-navbar navbar-expand-lg navbar navbar-with-menu floating-nav navbar-light navbar-shadow">
        <div class="navbar-wrapper">
            <div class="navbar-container content">
                <div class="navbar-collapse" id="navbar-mobile">
                    <div class="mr-auto float-left bookmark-wrapper d-flex align-items-center">
                        <ul class="nav navbar-nav">
                            <li class="nav-item mobile-menu d-xl-none mr-auto">
                                <a class="nav-link nav-menu-main menu-toggle hidden-xs" href="#">
                                    <i data-feather="menu"></i>
                                    {{-- <i class="ficon feather icon-menu"></i> --}}
                                </a>
                            </li>
                        </ul>
                        <ul class="nav navbar-nav bookmark-icons">
                            <!-- li.nav-item.mobile-menu.d-xl-none.mr-auto-->
                            <!--   a.nav-link.nav-menu-main.menu-toggle.hidden-xs(href='#')-->
                            <!--     i.ficon.feather.icon-menu-->
                            {{-- <li class="nav-item d-none d-lg-block">
                                <a class="nav-link" href="{{ url('admin/Newsletter') }}" data-toggle="tooltip" data-placement="top" title="Email">
                            <i data-feather="mail"></i>
                            </a>
                            </li> --}}
                        </ul>
                    </div>
                    <ul class="nav navbar-nav float-right">

                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-expand">
                                <i data-feather="maximize"></i>
                                {{-- <i class="ficon feather icon-maximize"></i> --}}
                            </a>
                        </li>

                        <li class="dropdown dropdown-user nav-item">
                            <a class="dropdown-toggle nav-link dropdown-user-link" href="#" data-toggle="dropdown">
                                <div class="user-nav d-sm-flex d-none">
                                    <span class="user-name text-bold-600">{{ Auth::user()->name }}</span>
                                    <span class="user-status">Available</span>
                                </div>
                                <span>
                                    <img class="shadow-none" src="{{asset('/images/loader.png')}}" alt="avatar" height="40" width="40">
                                </span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right">

                                <a class="dropdown-item" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i data-feather="power"></i>
                                    Logout
                                </a>
                                <form id="logout-form" action="{{ url('/admin/logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!-- END: Header-->


    <!-- BEGIN: Main Menu-->
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item mr-auto">
                    <a class="navbar-brand" href="{{ url('admin/dashboard') }}">
                        <img src="{{asset('/images/loader.png')}}" class="img-fluid" width="45px">
                        {{-- <div class="brand-logo"></div> --}}
                        <h6 class="brand-title mb-0 ml-1 text-wrap">{{env('APP_NAME')}}</h6>
                    </a>
                </li>
                <li class="nav-item nav-toggle">
                    <a class="nav-link modern-nav-toggle pr-0" data-toggle="collapse">
                        <i data-feather="x" class=" d-block d-xl-none font-medium-4 primary toggle-icon"></i>
                        <i data-feather="disc" class="toggle-icon font-medium-4 d-none d-xl-block collapse-toggle-icon primary" data-ticon="icon-disc"></i>
                        {{-- <i class="feather icon-x d-block d-xl-none font-medium-4 primary toggle-icon"></i> --}}
                        {{-- <i class="toggle-icon feather icon-disc font-medium-4 d-none d-xl-block collapse-toggle-icon primary" data-ticon="icon-disc"></i> --}}
                    </a>
                </li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <div class="main-menu-content">
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class=" nav-item">
                    <a href="{{ url('admin/dashboard') }}">
                        <i data-feather="home"></i>
                        <span class="menu-title" data-i18n="Dashboard">Dashboard</span>
                    </a>
                </li>

                <li class=" nav-item {{ Request::is('admin/contact') || Request::is('admin/contact/*') ? 'active' : null }}">
                    <a href="{{ url('admin/contact') }}" class="">
                        <i data-feather="mail" class=""></i>
                        <span class="menu-title" data-i18n="User">Contacts</span>
                    </a>
                </li>

                <li class=" nav-item {{ Request::is('admin/careers') || Request::is('admin/careers/*') ? 'active' : null }}">
                    <a href="{{ url('admin/careers') }}" class="">
                        <i data-feather="briefcase" class=""></i>
                        <span class="menu-title" data-i18n="User">Careers</span>
                    </a>
                </li>

                <li class=" nav-item {{ Request::is('admin/clients') || Request::is('admin/clients/*') ? 'active' : null }}">
                    <a href="{{ url('admin/clients') }}" class="">
                        <i data-feather="users" class=""></i>
                        <span class="menu-title" data-i18n="User">Clients</span>
                    </a>
                </li>

                <li class=" nav-item {{ Request::is('admin/projects') || Request::is('admin/projects/*') ? 'active' : null }}">
                    <a href="{{ url('admin/projects') }}" class="">
                        <i data-feather="coffee" class=""></i>
                        <span class="menu-title" data-i18n="User">Projects</span>
                    </a>
                </li>
                <li class=" nav-item {{ Request::is('admin/applicants') || Request::is('admin/applicants/*') ? 'active' : null }}">
                    <a href="{{ url('admin/applicants') }}" class="">
                        <i data-feather="coffee" class=""></i>
                        <span class="menu-title" data-i18n="User">Applicants</span>
                    </a>
                </li>
                {{-- <li class=" nav-item {{ Request::is('admin/products') ? 'active' : null }}">
                <a href="{{ url('admin/products') }}" class="">
                    <i data-feather="shopping-cart" class=""></i>
                    <span class="menu-title" data-i18n="User">Products</span>
                </a>
                </li>

                <li class=" nav-item {{ Request::is('admin/orders') ? 'active' : null }}">
                    <a href="{{ url('admin/orders') }}" class="">
                        <i data-feather="book" class=""></i>
                        <span class="menu-title" data-i18n="User">Orders</span>
                    </a>
                </li> --}}
            </ul>
        </div>
    </div>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    @yield('content')
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        <p class="clearfix blue-grey lighten-2 mb-0">
            <span class="float-md-left d-block d-md-inline-block mt-25">COPYRIGHT &copy; {{ date('Y') }}
                <a class="text-bold-800 grey darken-2" href="" target="_blank">{{ env('APP_NAME') }},</a>
                All rights Reserved
            </span>
            <span class="float-md-right d-none d-md-block">
                R Web Solutions Corp.
                <i data-feather="heart" class="pink"></i>
                {{-- <i class="feather icon-heart pink"></i> --}}
            </span>
            <button class="btn btn-primary btn-icon scroll-top" type="button">
                <i data-feather="arrow-up"></i>
                {{-- <i class="feather icon-arrow-up"></i> --}}
            </button>
        </p>
    </footer>
    <!-- END: Footer-->


    <!-- BEGIN: Vendor JS-->
    <script src="{{ asset('js/admin.min.js') }}"></script>
    {{-- <script src="{{ asset('js/admin.js') }}"></script> --}}

    {{-- <script src="{{ asset('js/filereader.min.js') }}"></script> --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
    <script type="text/javascript">
        feather.replace({
            class: 'foobar'
        });
    </script>

    @if (Session::has('uploading'))
    <script>
        let timerInterval
        Swal.fire({
            title: 'Updating...',
            timer: 1,
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading()
            },
            willClose: () => {
                clearInterval(timerInterval)
            }
        })
    </script>
    @endif
    {{-- @if (Session::has('uploading'))
        <script>
            let timerInterval
            Swal.fire({
            title: 'Auto close alert!',
            html: 'I will close in <b></b> milliseconds.',
            timer: 2000,
            timerProgressBar: true,
            didOpen: () => {
                Swal.showLoading()
                const b = Swal.getHtmlContainer().querySelector('b')
                timerInterval = setInterval(() => {
                b.textContent = Swal.getTimerLeft()
                }, 100)
            },
            willClose: () => {
                clearInterval(timerInterval)
            }
            }).then((result) => {
            /* Read more about handling dismissals below */
            if (result.dismiss === Swal.DismissReason.timer) {
                console.log('I was closed by the timer')
            }
            })
        </script>
    @endif --}}

    @yield('js')
</body>
<!-- END: Body-->

</html>