@extends('layouts.admin.app')
@section('content')
    <div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('home') }}">Home</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('admin/products') }}">Products</a>
                                    </li>
                                    <li class="breadcrumb-item active">
                                        Update
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')

            <div class="content-body bg-white p-3">
                <form method="post" class="row" action="{{ url('admin/products/'.$data->id) }}" enctype="multipart/form-data">
                    @csrf @method('put')
                    <div class="form-group col-lg-12">
                        <small>Thumbnail Image Should be less than 1mb </small>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" class="position-absolute form-control opacity-0" name="image[]" id="file" accept=".png,.jpeg,.jpg" multiple  style="opacity: 0">
                                <label class="form-control light_gray file-label" for="file">Upload multiple</label>
                                <div class="input-group-append">
                                    <span class="input-group-text" id="basic-addon2">Browse</span>
                                </div>
                            </div>
                        </div>
                        <div id="alert-col">
                        </div>
                        <div class="gallery" id="gallery2">
                            @foreach (json_decode($data->image) as $item)
                            <img src="{{ asset('uploads/products/thumbnail/'.$item) }}" class="img-fluid">
                            @endforeach
                        </div>
                    </div>
                    
                    <div class="form-group col-lg-12">
                        <small>Price*</small>
                        <input type="text" name="price" class="form-control" value="{{ $data->price }}" placeholder="Price" required="">
                    </div>

                    <div class="form-group col-lg-12">
                        <small>Active or Inactive</small>
                        <select name="active" class="form-control" required>
                            <option value="1" @if($data->active == 1) selected @endif>Active</option>
                            <option value="0" @if($data->active == 0) selected @endif>Inactive</option>
                        </select>
                    </div>
                    
                    <div class="form-group col-lg-12">
                        <small>Name*</small>
                        <input type="text" name="name" class="form-control" value="{{ $data->name }}" placeholder="Name" required="">
                    </div>

                    <div class="form-group col-lg-12">
                        <small>Category*</small>
                        <select name="category" class="form-control" required>
                            <option value="" selected>Select Category</option>
                            <option value="1" @if($data->category === '1') selected @endif>1</option>

                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <small>Description</small>
                        <textarea name="description" id="description" class="form-control" rows="5" required="">{!! $data->description !!}</textarea>
                    </div>

                    {{-- <div class="form-group col-lg-12">
                        <small>Specs Image Should be less than 1mb </small>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="img_specs" id="spec_image_file" accept=".png,.jpeg,.jpg" >
                                <label class="custom-file-label light_gray" for="exampleInputFile">UPLOAD ONE(1) IMAGE </label>
                            </div>
                        </div>
                        <div id="alert-col">
                        </div>
                        <div class="previewgallery" id="previewgallery2">
                            <img src="{{ asset('uploads/products/specs/'.$data->img_specs) }}" class="img-fluid">
                        </div>
                    </div> --}}

                    <div class="form-group text-center col-lg-12">
                        <button class="btn btn-primary" type="submit" id="submit">SUBMIT</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('js/filereader.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
    <script type="text/javascript">
        CKEDITOR.replace('description');

        $(function() {
            // Multiple images preview in browser
            let imagesPreview = function(input, placeToInsertImagePreview) {

                if (input.files) {
                    let filesAmount = input.files.length;
                    let filename = ''
                    for (i = 0; i < filesAmount; i++) {
                        let reader = new FileReader();

                        reader.onload = function(event) {
                            $($.parseHTML('<img>')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                        }

                        console.log(input.files[i].name)
                        filename += input.files[i].name +' | '

                        reader.readAsDataURL(input.files[i]);
                    }
                    $('.file-label').text(filename)
                }

            };

            $('#file').on('change', function() {

                const fsize = this.files[0].size;
                const file = Math.round((fsize / 1048));
                if (file >= 1048) {
                    $('#file').addClass('is-invalid');
                    document.getElementById('alert-col').innerHTML = '<small class="text-danger">File too Big, please select a file less than 1mb </small>';
                    $('#submit').prop('disabled', true);
                }else{
                    $('#file').removeClass('is-invalid');
                    document.getElementById('alert-col').innerHTML = '';
                    $('#submit').prop('disabled', false);
                }

                $('#gallery2 img').remove();
                imagesPreview(this, 'div.gallery');
            });
        });


    </script>
@stop
