<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php echo $__env->yieldContent('meta'); ?>

    <!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('/images/favicons/apple-touch-icon.png')); ?>" />
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('/images/favicons/favicon-32x32.png')); ?>" />
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('/images/favicons/favicon-16x16.png')); ?>" />
    <link rel="manifest" href="<?php echo e(asset('/images/favicons/site.webmanifest')); ?>" />

    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap JS & jQuery -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/bootstrap/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/animate/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/animate/custom-animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/fontawesome/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/jarallax/jarallax.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/jquery-magnific-popup/jquery.magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/nouislider/nouislider.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('vendors/nouislider/nouislider.pips.css')); ?>/" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/odometer/odometer.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/swiper/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/kontin-icons/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/tiny-slider/tiny-slider.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/reey-font/stylesheet.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/owl-carousel/owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/owl-carousel/owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/twentytwenty/twentytwenty.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/bxslider/jquery.bxslider.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/bootstrap-select/css/bootstrap-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/vegas/vegas.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/jquery-ui/jquery-ui.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/vendors/timepicker/timePicker.css')); ?>" />

    <!-- template styles -->
    <link rel="stylesheet" href="<?php echo e(asset('/css/kontin.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/css/kontin-responsive.css')); ?>" />

    <?php echo $__env->yieldContent('css'); ?>
    <style>
        .active-subnav {
            background-color: #b00818 !important;
            color: #fff !important;
        }

        .active-insidenav {
            color: var(--thm-primary);
        }

        .text-website-primary {
            color: #b00818 !important;
        }

        .text-website-secondary {
            color: #ffc000 !important;
        }
    </style>
    <style>
        /*--------------------------------------------------------------
>>> TABLE OF CONTENTS:
----------------------------------------------------------------
# Utility
# Cards
# Common
# Form
# Navigations
# Animations
# Mobile Nav
# Search Popup
# Page Header
# Google Map
# Client Carousel
--------------------------------------------------------------*/

        /*--------------------------------------------------------------
# Common
--------------------------------------------------------------*/
        :root {
            --thm-font: 'Arial';
            /* --thm-font: 'Roboto', sans-serif; */
            --thm-reey-font: 'reeyregular';
            --thm-gray: #767676;
            --thm-gray-rgb: 118, 118, 118;
            --thm-primary: #b00818;
            --thm-primary-rgb: 176, 8, 24;
            --thm-black: #171717;
            --thm-black-rgb: 23, 23, 23;
            --thm-base: #ffffff;
            --thm-base-rgb: 255, 255, 255;
            --thm-clr-extra: #e3e3e3;
        }

        .row {
            --bs-gutter-x: 30px;
        }

        .gutter-y-30 {
            --bs-gutter-y: 30px;
        }

        body {
            font-family: var(--thm-font);
            color: var(--thm-gray);
            font-size: 16px;
            line-height: 34px;
            font-weight: 400;
        }

        body.locked {
            overflow: hidden;
        }

        a {
            color: #000000;
        }

        a,
        a:hover,
        a:focus,
        a:visited {
            text-decoration: none;
        }

        ::placeholder {
            color: inherit;
            opacity: 1;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            color: var(--thm-black);
            margin: 0;
        }

        dl,
        ol,
        ul {
            margin-top: 0;
            margin-bottom: 0;
        }

        ::placeholder {
            color: inherit;
            opacity: 1;
        }


        .page-wrapper {
            position: relative;
            margin: 0 auto;
            width: 100%;
            min-width: 300px;
            overflow: hidden;
        }

        .container {
            padding-left: 15px;
            padding-right: 15px;
        }

        @media (min-width: 1200px) {
            .container {
                max-width: 1200px;
            }
        }

        ::placeholder {
            color: inherit;
            opacity: 1;
        }

        .section-separator {
            border-color: var(--thm-border);
            border-width: 1px;
            margin-top: 0;
            margin-bottom: 0;
        }

        /*Btn Style One*/

        .btn-style-one {
            position: relative;
            display: inline-block;
            text-align: center;
            text-transform: uppercase;
            background: var(--thm-primary);
            color: var(--thm-base);
            border-radius: 0;
            margin: 0;
            padding: 0;
            overflow: hidden;
            transition: all 0.3s ease;
            -moz-transition: all 0.3s ease;
            -webkit-transition: all 0.3s ease;
            -ms-transition: all 0.3s ease;
            -o-transition: all 0.3s ease;
        }

        .btn-style-one .btn-title {
            position: relative;
            display: block;
            font-size: 14px;
            line-height: 24px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            border-radius: 0;
            padding: 27px 60px 24px;
            z-index: 1;
        }

        .btn-style-one:hover {
            background: var(--thm-primary);
            color: #ffffff;
        }

        .btn-style-one .btn-curve {
            position: absolute;
            right: -15px;
            top: 0;
            width: 30px;
            height: 100%;
            background: rgba(var(--thm-black-rgb), .10);
            z-index: 0;
            transform: skewX(-22deg);
            transition: all 0.5s ease;
            -moz-transition: all 0.5s ease;
            -webkit-transition: all 0.5s ease;
            -ms-transition: all 0.5s ease;
            -o-transition: all 0.5s ease;
        }

        .btn-style-one:hover .btn-curve {
            background: rgba(var(--thm-black-rgb), 1);
            right: 0;
            width: 100%;
            transform: skewX(0deg);
        }



        .section-title {
            margin-top: -15px;
            margin-bottom: 47px;
        }

        .section-title__tagline {
            display: inline-flex;
            color: #000000;
            font-size: 14px;
            align-items: center;
            line-height: 30px;
            margin-bottom: 3px;
            font-weight: 500;
            letter-spacing: 0.2em;
            text-transform: uppercase;
        }

        .section-title__tagline::before {
            content: '';
            background-color: var(--thm-primary);
            width: 10px;
            height: 2px;
            margin-right: 10px;
        }

        .section-title__title {
            margin: 0;
            font-weight: 700;
            color: var(--thm-black);
            font-size: 50px;
            line-height: 60px;
        }

        .bootstrap-select .btn-light:not(:disabled):not(.disabled).active,
        .bootstrap-select .btn-light:not(:disabled):not(.disabled):active,
        .bootstrap-select .show>.btn-light.dropdown-toggle {
            box-shadow: none !important;
            outline: none !important;
        }

        .bootstrap-select>.dropdown-toggle {
            box-shadow: none !important;
        }

        .bootstrap-select .dropdown-toggle:focus,
        .bootstrap-select>select.mobile-device:focus+.dropdown-toggle {
            outline: none !important;
        }

        .bootstrap-select .dropdown-menu {
            border: 0;
            padding-top: 0;
            padding-bottom: 0;
            margin-top: 0;
            z-index: 991;
            border-radius: 0;
            display: flex;
            /* Arrange items in a row */
            flex-wrap: nowrap;
            /* Ensure items stay in a single line */
            justify-content: flex-start;
            /* Align items to the left */
        }

        .bootstrap-select .dropdown-menu>li {
            display: inline-block;
            /* Arrange list items horizontally */
        }

        .bootstrap-select .dropdown-menu>li+li>a {
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }

        .bootstrap-select .dropdown-menu>li.selected>a {
            background: var(--thm-primary);
            color: #fff;
        }

        .bootstrap-select .dropdown-menu>li>a {
            font-size: 16px;
            font-weight: 500;
            padding: 4px 20px;
            color: #ffffff;
            background: var(--thm-black);
            -webkit-transition: all 0.4s ease;
            transition: all 0.4s ease;
        }

        .bootstrap-select .dropdown-menu>li>a:hover {
            background: var(--thm-primary);
            color: #fff;
            cursor: pointer;
        }


        .preloader {
            position: fixed;
            background-color: #fff;
            background-position: center center;
            background-repeat: no-repeat;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 9991;
            display: -webkit-box;
            display: flex;
            -webkit-box-pack: center;
            justify-content: center;
            -webkit-box-align: center;
            align-items: center;
            text-align: center;
        }

        .preloader__image {
            -webkit-animation-fill-mode: both;
            animation-fill-mode: both;
            -webkit-animation-name: flipInY;
            animation-name: flipInY;
            -webkit-animation-duration: 2s;
            animation-duration: 2s;
            -webkit-animation-iteration-count: infinite;
            animation-iteration-count: infinite;
        }

        /* scroll to top */
        .scroll-to-top {
            display: inline-block;
            width: 45px;
            height: 45px;
            background: var(--thm-primary);
            position: fixed;
            bottom: 40px;
            right: 40px;
            z-index: 99;
            text-align: center;
            -webkit-transition: all 0.4s ease;
            transition: all 0.4s ease;
            display: none;
            border-radius: 50%;
            transition: all 0.4s ease;
        }

        .scroll-to-top i {
            color: #ffffff;
            font-size: 18px;
            line-height: 45px;
        }

        .scroll-to-top:hover {
            background-color: var(--thm-black);
        }

        .scroll-to-top:hover i {
            color: #fff;
        }

        /*--------------------------------------------------------------
# Navigations One
--------------------------------------------------------------*/
        .main-header {
            position: relative;
            display: block;
            background: var(--thm-base);
        }

        .main-header__top {
            position: relative;
            display: block;
            overflow: hidden;
            padding: 2.5px 0px;
            background-color: var(--thm-black);
        }

        .main-header__top-inner {
            position: relative;
            display: block;
            padding: 2.5px 0;
        }

        .main-header__top-left {
            position: relative;
            display: block;
            float: left;
        }

        .main-header__top-address {
            position: relative;
            display: flex;
            align-items: center;
        }

        .main-header__top-address li {
            position: relative;
            display: flex;
            align-items: center;
        }

        .main-header__top-address li+li {
            margin-left: 20px;
        }

        .main-header__top-address li .icon {
            display: flex;
            align-items: center;
        }

        .main-header__top-address li .icon span {
            font-size: 14px;
            color: var(--thm-primary);
        }

        .main-header__top-address li .text {
            margin-left: 10px;
        }

        .main-header__top-address li .text p {
            font-size: 12px;
            font-weight: 500;
            color: #aeaeae;
            margin: 0;
        }

        .main-header__top-address li .text a {
            font-size: 12px;
            font-weight: 500;
            color: #aeaeae;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .main-header__top-address li .text a:hover {
            color: var(--thm-base);
        }

        .main-header__top-right {
            position: relative;
            display: block;
            float: right;
        }

        .main-header__top-right-social {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            padding: 10px 0;
        }

        .main-header__top-right-social a {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: var(--thm-base);
            font-size: 15px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .main-header__top-right-social a:hover {
            color: var(--thm-primary);
        }

        .main-header__top-right-social a+a {
            margin-left: 25px;
        }

        .main-menu {
            position: relative;
            padding: 0 0;
            z-index: 91;
        }

        .main-menu-wrapper {
            position: relative;
            display: block;
        }

        .main-menu-wrapper-inner {
            position: relative;
            display: block;
        }

        .main-menu-wrapper__left {
            position: relative;
            display: block;
            float: left;
        }

        .main-menu-wrapper__logo {
            position: relative;
            float: left;
            padding-top: 33px;
            padding-bottom: 33px;
            margin-right: 50px;
        }

        .main-menu-wrapper__main-menu {
            position: relative;
            display: block;
            float: left;
        }

        .main-menu-wrapper__right {
            position: relative;
            display: block;
            float: right;
            padding: 24.5px 0;
        }

        .main-menu-wrapper__call {
            position: relative;
            display: flex;
            align-items: center;
        }

        .main-menu-wrapper__call-icon {
            height: 50px;
            width: 50px;
            background-color: #f3f3f3;
            font-size: 30px;
            color: var(--thm-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .main-menu-wrapper__call:hover .main-menu-wrapper__call-icon {
            background-color: var(--thm-black);
            color: var(--thm-base);
        }

        .main-menu-wrapper__call-icon .span {}

        .main-menu-wrapper__call-number {
            margin-left: 20px;
        }

        .main-menu-wrapper__call-number a {
            color: var(--thm-black);
            font-size: 16px;
            font-weight: 500;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .main-menu-wrapper__call-number a:hover {
            color: var(--thm-primary);
        }

        .main-menu-wrapper__call-number p {
            font-size: 14px;
            margin: 0;
            line-height: 17px;
        }


        .stricky-header.main-menu {
            padding: 0 0;
            background-color: var(--thm-base);
        }

        .main-menu .main-menu__list,
        .main-menu .main-menu__list ul,
        .stricky-header .main-menu__list,
        .stricky-header .main-menu__list ul {
            margin: 0;
            padding: 0;
            list-style-type: none;
            align-items: center;
            display: none;
        }

        @media (min-width: 1200px) {

            .main-menu .main-menu__list,
            .main-menu .main-menu__list ul,
            .stricky-header .main-menu__list,
            .stricky-header .main-menu__list ul {
                display: flex;
            }
        }

        .main-menu .main-menu__list>li,
        .stricky-header .main-menu__list>li {
            padding-top: 33px;
            padding-bottom: 33px;
            position: relative;
        }

        .main-menu .main-menu__list>li+li,
        .stricky-header .main-menu__list>li+li {
            margin-left: 23px;
        }

        .main-menu .main-menu__list>li>a,
        .stricky-header .main-menu__list>li>a {
            font-size: 16px;
            font-weight: 500;
            display: flex;
            align-items: center;
            color: var(--thm-gray);
            position: relative;
            transition: all 500ms ease;
        }

        .main-menu .main-menu__list>li>a::before,
        .stricky-header .main-menu__list>li>a::before {
            content: '';
            width: 100%;
            /* Make it cover full width */
            height: 2px;
            /* Keep the height of the underline */
            margin-top: 20px;
            background-color: var(--thm-primary);
            position: absolute;
            bottom: 0;
            /* Position it at the bottom */
            left: 0;
            transition: transform 500ms ease;
            transform: scale(0) translateX(0);
            z-index: -1;
        }

        .main-menu .main-menu__list>li.current>a,
        .main-menu .main-menu__list>li:hover>a,
        .stricky-header .main-menu__list>li.current>a,
        .stricky-header .main-menu__list>li:hover>a {
            color: var(--thm-black);
        }

        .main-menu .main-menu__list>li.current>a::before,
        .main-menu .main-menu__list>li:hover>a::before,
        .stricky-header .main-menu__list>li.current>a::before,
        .stricky-header .main-menu__list>li:hover>a::before {
            transform: scale(1) translateX(0);
            /* Ensure the underline appears */
        }

        .main-menu .main-menu__list>li.current>a::before {
            background-color: var(--thm-primary);
        }

        .main-menu .main-menu__list>li:hover>a::before {
            background-color: var(--thm-primary);
        }

        .main-menu .main-menu__list li ul,
        .stricky-header .main-menu__list li ul {
            position: absolute;
            top: 100%;
            left: 0;
            min-width: 220px;
            background-color: #fff;
            flex-direction: column;
            justify-content: flex-start;
            align-items: flex-start;
            opacity: 0;
            visibility: hidden;
            transition: 500ms ease;
            z-index: 99;
            box-shadow: 0px 0px 65px 0px rgba(0, 0, 0, 0.1);
        }

        .main-menu .main-menu__list li:hover>ul,
        .stricky-header .main-menu__list li:hover>ul {
            opacity: 1;
            visibility: visible;
        }

        .main-menu .main-menu__list li ul li,
        .stricky-header .main-menu__list li ul li {
            flex: 1 1 100%;
            width: 100%;
            position: relative;
        }

        .main-menu .main-menu__list li ul li+li,
        .stricky-header .main-menu__list li ul li+li {
            border-left: 1px solid RGBA(var(--thm-black), 0.1);
            /* Change border to left for horizontal */
        }

        .main-menu .main-menu__list li ul li a,
        .stricky-header .main-menu__list li ul li a {
            font-size: 16px;
            line-height: 30px;
            color: var(--thm-black);
            display: flex;
            padding-left: 20px;
            padding-right: 20px;
            padding-top: 10px;
            padding-bottom: 10px;
            transition: 500ms;
        }

        .main-menu .main-menu__list li ul li:hover>a,
        .stricky-header .main-menu__list li ul li:hover>a {
            background-color: var(--thm-primary);
            color: #fff;
        }

        .main-menu .main-menu__list li ul li>ul,
        .stricky-header .main-menu__list li ul li>ul {
            top: 0;
            left: 100%;
        }

        .main-menu .main-menu__list li ul li>ul.right-align,
        .stricky-header .main-menu__list li ul li>ul.right-align {
            top: 0;
            left: auto;
            right: 100%;
        }

        .main-menu .main-menu__list li ul li>ul ul,
        .stricky-header .main-menu__list li ul li>ul ul {
            display: none;
        }

        .stricky-header {
            position: fixed;
            z-index: 991;
            top: 0;
            left: 0;
            background-color: #fff;
            width: 100%;
            visibility: hidden;
            transform: translateY(-120%);
            transition: transform 500ms ease, visibility 500ms ease;
            box-shadow: 0px 10px 60px 0px rgba(0, 0, 0, 0.05);
        }

        @media (max-width: 1199px) {
            .stricky-header {
                display: none !important
            }
        }

        .stricky-header.stricky-fixed {
            transform: translateY(0);
            visibility: visible;
        }

        .stricky-header .main-menu__inner {
            box-shadow: none;
            padding-right: 0;
            max-width: 1170px;
            width: 100%;
            margin: 0 auto;
        }

        .mobile-nav__buttons {
            display: flex;
            margin-left: auto;
            margin-right: 10px;
        }

        @media (min-width: 1200px) {
            .mobile-nav__buttons {
                display: none;
            }
        }

        .mobile-nav__buttons a {
            font-size: 20px;
            color: var(--thm-black);
            cursor: pointer;
        }

        .mobile-nav__buttons a+a {
            margin-left: 10px;
        }

        .mobile-nav__buttons a:hover {
            color: var(--thm-base);
        }

        .main-menu .mobile-nav__toggler {
            font-size: 20px;
            color: var(--thm-primary);
            cursor: pointer;
            transition: 500ms;
            margin-right: 20px;
        }

        .main-menu .mobile-nav__toggler:hover {
            color: var(--thm-black);
        }

        @media (min-width: 1200px) {
            .main-menu .mobile-nav__toggler {
                display: none;
            }
        }

        /*--------------------------------------------------------------
# Navigations Two
--------------------------------------------------------------*/
        .main-header-two {
            background: transparent;
            position: absolute;
            left: 0px;
            top: 0px;
            width: 100%;
            z-index: 999;
            transition: all 500ms ease;
        }

        .main-header-two:before {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 1px;
            content: "";
            background-color: rgba(var(--thm-base-rgb), .15);
            z-index: -1;

        }

        .main-header-two__top {
            position: relative;
            display: block;
            background-color: var(--thm-black);
            padding: 2.5px 0;
        }

        .main-header-two__top-inner {
            position: relative;
            display: block;
            padding: 0 60px;
        }

        .main-header-two__top-left {
            position: relative;
            display: block;
            float: left;
        }

        .main-header-two__top-left-text {
            font-size: 12px;
            color: #aeaeae;
            font-weight: 500;
            margin: 0;
        }

        .main-header-two__top-left-text a {
            color: var(--thm-primary);
        }

        .main-header-two__top-right {
            position: relative;
            display: block;
            float: right;
        }


        .main-menu-two {
            padding: 0 15px;
        }

        @media(min-width: 992px) {
            .main-menu-two {
                padding: 0 30px;
            }
        }

        @media(min-width: 1200px) {
            .main-menu-two {
                padding: 0 60px;
            }
        }

        .main-menu-two-wrapper {
            position: relative;
            display: block;
        }

        .main-menu-two-wrapper__logo {
            position: relative;
            display: block;
            float: left;
            padding: 33px 0px;
        }

        .main-menu-two-wrapper__main-menu {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 80%;
            float: left;
        }

        .main-menu-two .main-menu__list>li>a,
        .stricky-header .main-menu-two .main-menu__list>li>a {
            font-size: 16px;
            font-weight: 400;
            display: flex;
            align-items: center;
            color: var(--thm-base);
            position: relative;
            transition: all 500ms ease;
        }

        .main-menu-two .main-menu__list>li.current>a,
        .main-menu-two .main-menu__list>li:hover>a,
        .stricky-header.main-menu-two .main-menu__list>li.current>a,
        .stricky-header.main-menu-two .main-menu__list>li:hover>a {
            color: var(--thm-base);
            text-shadow: 0 0 1px currentColor;
        }

        .main-menu-two-wrapper__right {
            position: relative;
            display: block;
            float: right;
        }

        .main-menu-two-wrapper__social {
            position: relative;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            padding: 27.5px 0;
        }

        .main-menu-two-wrapper__social a {
            position: relative;
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: #aeaeae;
            background-color: #000000;
            border-radius: 50%;
            font-size: 13px;
            height: 45px;
            width: 45px;
            transform: rotate(0);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            z-index: 1;
        }

        .main-menu-two-wrapper__social a:hover {
            color: var(--thm-black);
            transform: rotate(360deg);
        }

        .main-menu-two-wrapper__social a:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: var(--thm-base);
            border-radius: 50%;
            transform: scale(0.0);
            transform-origin: center;
            transform-style: preserve-3d;
            transition: all 0.4s cubic-bezier(0.62, 0.21, 0.45, 1.52);
            z-index: -1;
        }

        .main-menu-two-wrapper__social a:hover:before {
            transform: scaleX(1.0);
        }

        .main-menu-two-wrapper__social a+a {
            margin-left: 10px;
        }

        .stricky-header.main-menu-two {
            padding: 0 60px;
            background-color: var(--thm-black);
        }

        /*--------------------------------------------------------------
# Animations
--------------------------------------------------------------*/
        @keyframes  bubbleMover {
            0% {
                -webkit-transform: translateY(0px) translateX(0) rotate(0);
                transform: translateY(0px) translateX(0) rotate(0);
            }

            30% {
                -webkit-transform: translateY(30px) translateX(50px) rotate(15deg);
                transform: translateY(30px) translateX(50px) rotate(15deg);
                -webkit-transform-origin: center center;
                transform-origin: center center;
            }

            50% {
                -webkit-transform: translateY(50px) translateX(100px) rotate(45deg);
                transform: translateY(50px) translateX(100px) rotate(45deg);
                -webkit-transform-origin: right bottom;
                transform-origin: right bottom;
            }

            80% {
                -webkit-transform: translateY(30px) translateX(50px) rotate(15deg);
                transform: translateY(30px) translateX(50px) rotate(15deg);
                -webkit-transform-origin: left top;
                transform-origin: left top;
            }

            100% {
                -webkit-transform: translateY(0px) translateX(0) rotate(0);
                transform: translateY(0px) translateX(0) rotate(0);
                -webkit-transform-origin: center center;
                transform-origin: center center;
            }
        }

        @keyframes  shapeMover {

            0%,
            100% {
                transform: perspective(400px) translateY(0) rotate(0deg) translateZ(0px) translateX(0);
            }

            50% {
                transform: perspective(400px) rotate(0deg) translateZ(20px) translateY(20px) translateX(20px);
            }
        }

        @keyframes  banner3Shake {
            0% {
                -webkit-transform: rotate3d(0, 1, 0, 0deg);
                transform: rotate3d(0, 1, 0, 0deg);
            }

            30% {
                -webkit-transform: rotate3d(0, 0, 1, 5deg);
                transform: rotate3d(0, 0, 1, 5deg);
            }

            60% {
                -webkit-transform: rotate3d(1, 0, 0, 0deg);
                transform: rotate3d(1, 0, 0, 0deg);
            }

            80% {
                -webkit-transform: rotate3d(0, 0, 1, 5deg);
                transform: rotate3d(0, 0, 1, 5deg);
            }

            100% {
                -webkit-transform: rotate3d(0, 1, 0, 0deg);
                transform: rotate3d(0, 1, 0, 0deg);
            }
        }

        @keyframes  squareMover {

            0%,
            100% {
                -webkit-transform: translate(0, 0) rotate(0);
                transform: translate(0, 0) rotate(0);
            }

            20%,
            60% {
                -webkit-transform: translate(20px, 40px) rotate(180deg);
                transform: translate(20px, 40px) rotate(180deg);
            }

            30%,
            80% {
                -webkit-transform: translate(40px, 60px) rotate(0deg);
                transform: translate(40px, 60px) rotate(0deg);
            }
        }

        @keyframes  treeMove {

            0%,
            100% {
                -webkit-transform: rotate(0deg) translateX(0);
                transform: rotate(0deg) translateX(0);
            }

            25%,
            75% {
                -webkit-transform: rotate(5deg) translateX(15px);
                transform: rotate(5deg) translateX(15px);
            }

            50% {
                -webkit-transform: rotate(10deg) translateX(30px);
                transform: rotate(10deg) translateX(30px);
            }
        }


        /*--------------------------------------------------------------
#     Zoom Fade Css
--------------------------------------------------------------*/
        .zoom-fade {
            animation-name: zoom-fade;
            animation-duration: 5s;
            animation-iteration-count: infinite;
            animation-timing-function: linear;

            -webkit-animation-name: zoom-fade;
            -webkit-animation-duration: 5s;
            -webkit-animation-iteration-count: infinite;
            -webkit-animation-timing-function: linear;

            -moz-animation-name: zoom-fade;
            -moz-animation-duration: 5s;
            -moz-animation-iteration-count: infinite;
            -moz-animation-timing-function: linear;

            -ms-animation-name: zoom-fade;
            -ms-animation-duration: 5s;
            -ms-animation-iteration-count: infinite;
            -ms-animation-timing-function: linear;

            -o-animation-name: zoom-fade;
            -o-animation-duration: 5s;
            -o-animation-iteration-count: infinite;
            -o-animation-timing-function: linear;
        }

        @-webkit-keyframes zoom-fade {
            0% {
                -webkit-transform: scale(0.9);
                transform: scale(0.9);
            }

            50% {
                -webkit-transform: scale(1);
                transform: scale(1);
            }

            100% {
                -webkit-transform: scale(0.9);
                transform: scale(0.9);
            }
        }

        @keyframes  zoom-fade {
            0% {
                -webkit-transform: scale(0.9);
                transform: scale(0.9);
            }

            50% {
                -webkit-transform: scale(1);
                transform: scale(1);
            }

            100% {
                -webkit-transform: scale(0.9);
                transform: scale(0.9);
            }
        }



        @-moz-keyframes service_hexagon_2 {
            0% {
                -moz-transform: rotateY(0deg);
                transform: rotateY(0deg)
            }

            100% {
                -moz-transform: rotateY(360deg);
                transform: rotateY(360deg)
            }
        }

        @-o-keyframes service_hexagon_2 {
            0% {
                -o-transform: rotateY(0deg);
                transform: rotateY(0deg)
            }

            100% {
                -o-transform: rotateY(360deg);
                transform: rotateY(360deg)
            }
        }

        @keyframes  service_hexagon_2 {
            0% {
                -webkit-transform: rotateY(0deg);
                -moz-transform: rotateY(0deg);
                -o-transform: rotateY(0deg);
                transform: rotateY(0deg)
            }

            100% {
                -webkit-transform: rotateY(360deg);
                -moz-transform: rotateY(360deg);
                -o-transform: rotateY(360deg);
                transform: rotateY(360deg)
            }
        }

        /*--------------------------------------------------------------
# Mobile Nav
--------------------------------------------------------------*/
        .mobile-nav__wrapper {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            /* z-index: 999999; */
            z-index: 100;
            transform: translateX(-100%);
            -webkit-transform-origin: left center;
            transform-origin: left center;
            transition: transform 500ms ease 500ms, visibility 500ms ease 500ms;
            visibility: hidden;
        }

        .mobile-nav__wrapper .container {
            padding-left: 0;
            padding-right: 0;
        }

        .mobile-nav__wrapper.expanded {
            opacity: 1;
            transform: translateX(0%);
            visibility: visible;
            transition: transform 500ms ease 0ms, visibility 500ms ease 0ms;
        }

        .mobile-nav__overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #000000;
            opacity: 0.5;
            cursor: pointer;
        }

        .mobile-nav__content {
            width: 300px;
            background-color: var(--thm-black);
            z-index: 10;
            position: relative;
            height: 100%;
            overflow-y: auto;
            padding-top: 30px;
            padding-bottom: 30px;
            padding-left: 15px;
            padding-right: 15px;

            opacity: 0;
            visibility: hidden;
            transform: translateX(-100%);
            transition: opacity 500ms ease 0ms, visibility 500ms ease 0ms, transform 500ms ease 0ms;
        }


        .mobile-nav__wrapper.expanded .mobile-nav__content {
            opacity: 1;
            visibility: visible;
            transform: translateX(0);
            transition: opacity 500ms ease 500ms, visibility 500ms ease 500ms, transform 500ms ease 500ms;
        }


        .mobile-nav__content .thm-btn {
            padding: 8px 0;
            width: 100%;
            text-align: center;
        }

        .mobile-nav__content .logo-box {
            margin-bottom: 40px;
            display: flex;
        }

        .mobile-nav__close {
            position: absolute;
            top: 20px;
            right: 15px;
            font-size: 18px;
            color: var(--thm-text-dark);
            cursor: pointer;
        }

        .mobile-nav__content .main-menu__list,
        .mobile-nav__content .main-menu__list ul {
            margin: 0;
            padding: 0;
            list-style-type: none;
        }

        .mobile-nav__content .main-menu__list ul {
            display: none;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-nav__content .main-menu__list li:not(:last-child) {
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-nav__content .main-menu__list li a {
            display: flex;
            justify-content: space-between;
            line-height: 30px;
            color: #ffffff;
            font-size: 14px;
            font-family: var(--thm-font);
            font-weight: 500;
            height: 46px;
            align-items: center;
            transition: 500ms;
        }

        .mobile-nav__content .main-menu__list li a.expanded {
            color: var(--thm-secondary);
        }

        .mobile-nav__content .main-menu__list li a button {
            width: 30px;
            height: 30px;
            background-color: var(--thm-primary);
            border: none;
            outline: none;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            transform: rotate(-90deg);
            transition: transform 500ms ease;
        }

        .mobile-nav__content .main-menu__list li a button.expanded {
            transform: rotate(0deg);
            background-color: #fff;
            color: var(--thm-black);
        }

        .mobile-nav__content .main-menu__list li.cart-btn span {
            position: relative;
            top: auto;
            right: auto;
            transform: translate(0, 0);
        }

        .mobile-nav__content .main-menu__list li.cart-btn i {
            font-size: 16px;
        }

        .mobile-nav__top {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 30px;
        }

        .mobile-nav__top .main-menu__login a {
            color: var(--thm-text-dark);
        }

        .mobile-nav__container {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-nav__social {
            display: flex;
            align-items: center;
        }

        .mobile-nav__social a {
            font-size: 16px;
            color: var(--thm-primary);
            transition: 500ms;
        }

        .mobile-nav__social a+a {
            margin-left: 30px;
        }

        .mobile-nav__social a:hover {
            color: #ffffff;
        }

        .mobile-nav__contact {
            margin-bottom: 0;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        .mobile-nav__contact li {
            color: var(--thm-text-dark);
            font-size: 14px;
            font-weight: 500;
            position: relative;
            display: flex;
            align-items: center;
        }

        .mobile-nav__contact li+li {
            margin-top: 15px;
        }

        .mobile-nav__contact li a {
            color: #ffffff;
            transition: 500ms;
        }

        .mobile-nav__contact li a:hover {
            color: var(--thm-primary);
        }

        .mobile-nav__contact li>i {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: var(--thm-primary);
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            font-size: 11px;
            margin-right: 10px;
            color: #fff;
        }

        .mobile-nav__container .main-logo,
        .mobile-nav__container .topbar__buttons,
        .mobile-nav__container .main-menu__language,
        .mobile-nav__container .main-menu__login {
            display: none;
        }

        /*--------------------------------------------------------------
# Search Popup
--------------------------------------------------------------*/
        .search-popup {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            z-index: 9999;
            padding-left: 20px;
            padding-right: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            transform: translateY(-110%);
            transition: transform 500ms ease, opacity 500ms ease;
        }

        .search-popup.active {
            transform: translateY(0%);
        }

        .search-popup__overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: var(--thm-black);
            opacity: 0.75;
            cursor: pointer;
        }

        .search-popup__content {
            width: 100%;
            max-width: 560px;
        }

        .search-popup__content form {
            display: flex;
            flex-wrap: wrap;
            position: relative;
            background-color: #fff;
            border-radius: 0px;
            overflow: hidden;
        }

        .search-popup__content form input[type="search"],
        .search-popup__content form input[type="text"] {
            width: 100%;
            background-color: #fff;
            font-size: 16px;
            border: none;
            outline: none;
            height: 66px;
            padding-left: 30px;
        }

        .search-popup__content .thm-btn {
            padding: 0;
            width: 68px;
            height: 68px;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            position: absolute;
            top: 0;
            right: -1px;
            border-radius: 0;
            background-color: var(--thm-primary);
        }

        .search-popup__content .thm-btn:hover {
            background-color: var(--thm-black);
            color: #fff;
        }

        .search-popup__content .thm-btn i {
            margin: 0;
        }

        /*--------------------------------------------------------------
# Banner One
--------------------------------------------------------------*/
        .main-slider {
            overflow: hidden;
            position: relative;
        }

        .main-slider .swiper-slide {
            position: relative;
            background-color: var(--thm-black);
        }

        .main-slider .swiper-slide .container {
            position: relative;
            z-index: 30;
        }

        .main-slider .image-layer {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-repeat: no-repeat;
            background-size: cover;
            transform: scale(1);
            transition: transform 7000ms ease;
            z-index: 1;
        }

        .main-slider .image-layer-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            content: "";
            background: rgba(var(--thm-black-rgb), .5);
            z-index: 2;
        }

        .main-slider .container {
            padding-top: 224px;
            padding-bottom: 223px;
        }

        .main-slider__content {
            position: relative;
            display: block;
        }

        .main-slider__side-text {
            font-size: 30px;
            color: var(--thm-base);
            font-weight: 400;
            letter-spacing: 0.4em;
            text-transform: uppercase;
            position: absolute;
            top: 169px;
            left: -224px;
            opacity: 0;
            transform: translateY(100px) rotate(-90deg);
            transition-delay: 3000ms;
            transition: transform 3000ms ease,
                opacity 2500ms ease,
                color 500ms ease,
                background 500ms ease;
        }

        .main-slider .swiper-slide-active .main-slider__side-text {
            visibility: visible;
            opacity: .10;
            /* transform: translateY(0) translateX(0) rotate(-90deg); */
        }

        .main-slider h2 {
            margin: 0;
            margin-bottom: 25px;
            color: var(--thm-base);
            font-weight: 700;
            /* opacity: 0; */
            /* visibility: hidden; */
            transform: translateY(120px);
            transition-delay: 1000ms;
            transition: transform 2000ms ease, opacity 2000ms ease;
            font-size: 80px;
            line-height: 90px;
            z-index: 2;
        }

        .main-slider h2 .highlight {
            position: relative;
            display: inline-block;
            z-index: 1;
        }

        .main-slider h2 .highlight:before {
            content: "";
            position: absolute;
            top: -25px;
            left: -20px;
            bottom: -18px;
            right: -25px;
            background-image: url(../images/shapes/main-slider-shape-1.png);
            background-repeat: no-repeat;
            background-position: center center;
            background-size: 100% 100%;
            z-index: -1;

            animation-name: zoom-fade;
            animation-duration: 5s;
            animation-iteration-count: infinite;
            animation-timing-function: linear;
            -webkit-animation-name: zoom-fade;
            -webkit-animation-duration: 5s;
            -webkit-animation-iteration-count: infinite;
            -webkit-animation-timing-function: linear;
            -moz-animation-name: zoom-fade;
            -moz-animation-duration: 5s;
            -moz-animation-iteration-count: infinite;
            -moz-animation-timing-function: linear;
            -ms-animation-name: zoom-fade;
            -ms-animation-duration: 5s;
            -ms-animation-iteration-count: infinite;
            -ms-animation-timing-function: linear;
            -o-animation-name: zoom-fade;
            -o-animation-duration: 5s;
            -o-animation-iteration-count: infinite;
            -o-animation-timing-function: linear;
        }

        .main-slider p {
            font-size: 20px;
            color: var(--thm-base);
            font-weight: 400;
            margin: 0;
            margin-bottom: 52px;
            line-height: 30px;
            /* opacity: 0; */
            transform: translateY(100px);
            transition-delay: 2500ms;
            transition: transform 2000ms ease,
                opacity 2000ms ease,
                color 500ms ease,
                background 500ms ease;
        }

        .main-slider .btn-style-one {
            opacity: 0;
            transform: translateY(100px);
            transition-delay: 2500ms;
            transition: transform 2000ms ease,
                opacity 2000ms ease,
                color 500ms ease,
                background 500ms ease;
        }

        .main-slider__shape {
            position: absolute;
            top: -27px;
            right: 469px;
            z-index: -1;
        }

        .main-slider__shape img {}

        .main-slider .swiper-slide-active .btn-style-one {
            visibility: visible;
            opacity: 1;
            /* transform: translateY(0) translateX(0); */
        }

        .main-slider .swiper-slide-active p {
            visibility: visible;
            /* opacity: .7; */
            /* transform: translateY(0) translateX(0); */
        }

        .main-slider .swiper-slide-active .image-layer {
            /* transform: scale(1.15); */
        }

        .main-slider .swiper-slide-active h2 {
            visibility: visible;
            opacity: 1;
            /* transform: translateY(0) translateX(0); */
        }

        .main-slider__nav {
            position: absolute;
            bottom: 0;
            right: 0;
            z-index: 100;
            display: flex;
            align-items: center;
        }


        .main-slider__nav .swiper-button-next,
        .main-slider__nav .swiper-button-prev {
            position: relative;
            top: auto;
            left: auto;
            right: auto;
            bottom: auto;
            z-index: 100;
            width: 70px;
            height: 70px;
            font-size: 20px;
            color: var(--thm-black);
            background-color: var(--thm-base);
            opacity: 1;
            margin: 0;
            text-align: center;
            transition: all 500ms ease;
        }


        .main-slider__nav .swiper-button-next:hover,
        .main-slider__nav .swiper-button-prev:hover {
            color: var(--thm-base);
            background-color: var(--thm-primary);
        }

        .main-slider__nav .swiper-button-next::after,
        .main-slider__nav .swiper-button-prev::after {
            display: none;
        }

        .main-slider__nav .swiper-button-prev {
            margin-bottom: 0px;
        }

        .main-slider__nav .swiper-button-prev .icon-left-arrow {
            position: relative;
            transform: rotate(180deg);
        }

        #main-slider-pagination {
            z-index: 10;
            bottom: 49px;
            left: 50%;
            width: 100%;
            max-width: 1170px;
            -webkit-transform: translate(-50%, calc(-50% + 95px));
            transform: translate(-50%, calc(0% + 0px));
            text-align: center;
        }

        #main-slider-pagination .swiper-pagination-bullet {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            opacity: 0.6;
            background-color: #fff;
            -webkit-transition: all 300ms ease;
            transition: all 300ms ease;
        }

        #main-slider-pagination .swiper-pagination-bullet+.swiper-pagination-bullet {
            margin-left: 5px;
        }

        #main-slider-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active {
            width: 13px;
            height: 13px;
            opacity: 1;
        }

        /*--------------------------------------------------------------
# Main Slider Two
--------------------------------------------------------------*/
        .main-slider-two {}

        .main-slider-two .image-layer-overlay {
            background: rgba(var(--thm-black-rgb), .6);
        }

        .main-slider-two .container {
            padding-top: 346px;
            padding-bottom: 200px;
        }

        .main-slider-two h2 {
            position: relative;
            font-weight: 800;
            font-size: 100px;
            line-height: 90px;
            text-transform: uppercase;
            margin-bottom: 32px;
        }

        .main-slider-two h2:before {
            position: absolute;
            bottom: -13px;
            right: 282px;
            width: 377px;
            height: 23px;
            background-image: url(../images/shapes/main-slider-two-shape-1.png);
            background-repeat: no-repeat;
            content: "";
        }

        .main-slider-two p {
            margin-bottom: 47px;
        }

        .main-slider-two a {}






        /*--------------------------------------------------------------
# Welcome One
--------------------------------------------------------------*/
        .welcome-one {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .welcome-one__left {
            position: relative;
            display: block;
            margin-right: 70px;
        }

        .welcome-one__img-box {
            position: relative;
            display: block;
        }

        .welcome-one__img-box:before {
            position: absolute;
            top: 30px;
            left: -30px;
            bottom: 30px;
            background-color: var(--thm-primary);
            content: "";
            width: 30px;
        }

        .welcome-one__img {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .welcome-one__img:after {
            position: absolute;
            top: 0;
            left: -100%;
            display: block;
            content: '';
            width: 50%;
            height: 100%;
            background: linear-gradient(to right, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, .3) 100%);
            transform: skewX(-25deg);
            z-index: 1;
        }

        .welcome-one__img-box:hover .welcome-one__img:after {
            -webkit-animation: shine 1.5s;
            animation: shine 1.5s;
        }

        .welcome-one__img>img {
            width: 100%;
        }

        .welcome-one__small-img {
            position: absolute;
            bottom: -60px;
            right: -70px;
            z-index: 3;
        }

        .welcome-one__small-img>img {}

        .welcome-one__completed {
            position: absolute;
            top: 60px;
            left: -55px;
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .10);
            display: flex;
            align-items: center;
            padding: 33px 45px 33px;
        }

        .welcome-one__completed-icon {
            display: flex;
            align-items: center;
        }

        .welcome-one__completed-icon span {
            display: inline-block;
            font-size: 65px;
            color: var(--thm-primary);
            line-height: 65px;
            transition: all 500ms ease;
        }

        .welcome-one__img-box:hover .welcome-one__completed-icon span {
            transform: rotateY(180deg);
            color: var(--thm-black);
        }

        .welcome-one__completed-text {
            margin-left: 20px;
        }

        .welcome-one__completed-text h6 {
            font-size: 16px;
            color: var(--thm-gray);
            font-weight: 400;
            line-height: 26px;
        }

        .welcome-one__completed-text h6 span {
            font-size: 20px;
            font-weight: 700;
            color: var(--thm-black);
            font-family: var(--thm-font) !important;
        }

        .welcome-one__right {
            position: relative;
            display: block;
            margin-left: 70px;
        }

        .welcome-one__right .section-title {
            margin-bottom: 39px;
        }

        .welcome-one__right-text-1 {
            font-size: 20px;
            color: var(--thm-primary);
            font-weight: 500;
            margin: 0;
            line-height: 30px;
        }

        .welcome-one__right-text-2 {
            margin: 0;
            padding-top: 15px;
            padding-bottom: 38px;
        }

        .welcome-one__list {
            position: relative;
            display: block;
        }

        .welcome-one__list li {
            position: relative;
            display: flex;
            /* align-items: center; */
        }

        .welcome-one__list li+li {
            margin-top: 10px;
        }

        .welcome-one__list-icon {
            display: flex;
            /* align-items: center; */
        }

        .welcome-one__list-icon span {
            margin-top: 10px;
            font-size: 16px;
            color: var(--thm-primary);
        }

        .welcome-one__list-text {
            margin-left: 10px;
        }

        .welcome-one__list-text p {
            font-size: 18px;
            font-weight: 500;
            color: var(--thm-black);
            margin: 0;
        }

        .welcome-one__person {
            position: relative;
            display: flex;
            align-items: center;
            margin-top: 68px;
            padding-left: 44px;
        }

        .welcome-one__person:before {
            position: absolute;
            top: -8px;
            left: -1px;
            bottom: -8px;
            content: "";
            background-color: var(--thm-primary);
            width: 7px;
        }

        .welcome-one__person-img {
            position: relative;
            display: block;
            border-radius: 50%;
        }

        .welcome-one__person-img:before {
            position: absolute;
            top: -8px;
            left: -8px;
            right: -8px;
            bottom: -8px;
            content: "";
            border-style: solid;
            border-width: 1px;
            border-color: rgb(227, 227, 227);
            border-radius: 50%;
            background-color: rgba(255, 255, 255, 0);

        }


        .welcome-one__person-sign {
            margin-left: 30px;
        }

        .welcome-one__person-sign h3 {
            font-size: 24px;
            font-weight: 400;
            font-family: var(--thm-reey-font);
            line-height: 34px;
        }

        /*--------------------------------------------------------------
# Services One
--------------------------------------------------------------*/
        .services-one {
            position: relative;
            display: block;
            padding: 8px 0 165px;
        }

        .services-one:before {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            content: "";
            background-color: #f3f3f3;
            height: 462px;
            z-index: -1;
        }


        .services-one__single {
            position: relative;
            display: block;
            margin-bottom: 30px;
        }

        .services-one__img {
            position: relative;
            display: block;
            overflow: hidden;
            z-index: 1;
        }

        .services-one__img:before {
            position: absolute;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            content: "";
            border-radius: 0%;
            background-color: rgba(var(--thm-black-rgb), .40);
            z-index: 1;
            transform: scale(0.0) perspective(400px);
            transform-origin: bottom left;
            transform-style: preserve-3d;
            transition: all 700ms ease;
        }

        .services-one__single:hover .services-one__img:before {
            transform: scaleX(1.0) perspective(400px);
        }

        .services-one__img img {
            position: relative;
            width: 100%;
            transform: scale(1);
            -webkit-transition: all 0.5s ease 0s;
            -o-transition: all 0.5s ease 0s;
            transition: all 0.5s ease 0s;
        }

        .services-one__single:hover .services-one__img img {
            transform: scale(1.05);
        }

        .services-one__icon {
            position: absolute;
            bottom: 0;
            right: 20px;
            height: 100px;
            width: 100px;
            font-size: 65px;
            color: var(--thm-base);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 2;
        }

        .services-one__icon:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: var(--thm-primary);
            transition: all 500ms ease;
            z-index: -1;
        }

        .services-one__single:hover .services-one__icon:before {
            background-color: var(--thm-black);
        }

        .services-one__content {
            position: relative;
            display: block;
            border: 1px solid var(--thm-clr-extra);
            background-color: var(--thm-base);
            padding: 32px 40px 23px;
            border-top: 0;
            transition: all 500ms ease;
        }

        .services-one__single:hover .services-one__content {
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .07);
        }

        .services-one__title {
            font-size: 24px;
            font-weight: 700;
            line-height: 34px;
        }

        .services-one__title a {
            color: var(--thm-black);
            transition: all 500ms ease;
        }

        .services-one__single:hover .services-one__title a {
            color: var(--thm-primary);
        }

        .services-one__text {
            margin: 0;
            padding-top: 21px;
            padding-bottom: 18px;
        }

        .services-one__arrow {}

        .services-one__arrow a {
            font-size: 20px;
            color: var(--thm-black);
            transition: all 500ms ease;
        }

        .services-one__single:hover .services-one__arrow a {
            color: var(--thm-primary);
        }

        /*--------------------------------------------------------------
# Tabs Box One
--------------------------------------------------------------*/
        .tabs-box-one {
            position: relative;
            display: block;
            padding: 0 0 110px;
        }

        .tabs-box-one .tab-buttons {
            position: relative;
            display: block;
            overflow: hidden;
            margin-bottom: 80px;
            margin-top: -75px;
        }

        .tabs-box-one .tab-buttons .tab-btn {
            position: relative;
            display: inline-block;
        }

        .tabs-box-one .tab-buttons .tab-btn+.tab-btn {
            margin-left: 5px;
        }

        .tabs-box-one .tab-buttons .tab-btn span {
            position: relative;
            display: inline-block;
            transition: all 200ms linear;
            transition-delay: 0.1s;
            font-size: 18px;
            color: var(--thm-base);
            background-color: var(--thm-black);
            padding: 21px 60px 20px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 1;
        }

        .tabs-box-one .tab-buttons .tab-btn.active-btn span {
            color: var(--thm-black);
        }

        .tabs-box-one .tab-buttons .tab-btn span:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            height: 0%;
            content: "";
            background-color: var(--thm-base);
            transition: all 0.3s ease;
            z-index: -1;
        }

        .tabs-box-one .tab-buttons .tab-btn.active-btn span:before {
            height: 100%;
        }

        .tabs-box-one .tabs-content {}

        .tabs-box-one .tabs-content .tab {
            position: relative;
            display: none;
            -webkit-transform: translateY(35px);
            -ms-transform: translateY(35px);
            transform: translateY(35px);
            -webkit-transition: all 600ms ease;
            -moz-transition: all 600ms ease;
            -ms-transition: all 600ms ease;
            -o-transition: all 600ms ease;
            transition: all 600ms ease;
            z-index: 10;
        }

        .tabs-box-one .tabs-content .tab.active-tab {
            display: block;
            margin-top: 0px;
            -webkit-transform: translateY(0px);
            -ms-transform: translateY(0px);
            transform: translateY(0px);

        }

        .tabs-content__inner {
            position: relative;
            display: block;
        }

        .tabs-content__inner-left {
            position: relative;
            display: block;
        }

        .tabs-content__inner-img {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .tabs-content__inner-img::before {
            position: absolute;
            top: 50%;
            left: 50%;
            display: block;
            content: '';
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, .2);
            border-radius: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            opacity: 0;
            z-index: 10;
        }

        .tabs-content__inner-img:hover:before {
            -webkit-animation: circle .75s;
            animation: circle .75s;
        }

        .tabs-content__inner-img img {
            width: 100%;
        }

        .tabs-content__inner-right {
            position: relative;
            display: block;
            margin-left: 70px;
            margin-top: -11px;
        }

        .flex-row-reverse .tabs-content__inner-right {
            margin-left: 0;
            margin-right: 70px;
        }

        @media(max-width: 991px) {

            .flex-row-reverse .tabs-content__inner-right {
                margin-right: 0;
            }
        }

        .tabs-content__inner-right-text {
            font-size: 18px;
            line-height: 36px;
            margin: 0;
            padding-bottom: 30px;
        }

        .tabs-content__inner-list {
            position: relative;
            display: block;
        }

        .tabs-content__inner-list li {
            position: relative;
            display: flex;
            border-bottom: 1px solid var(--thm-clr-extra);
            padding-bottom: 38px;
            margin-bottom: 50px;
        }

        .tabs-content__inner-list li:last-child {
            border-bottom: 0;
            margin-bottom: 0;
            padding-bottom: 0;
        }

        .tabs-content__inner-list li .icon {
            position: relative;
            display: inline-block;
            top: 8px;
            transition: all 500ms ease;
        }

        .tabs-content__inner-list li:hover .icon {
            transform: rotateY(180deg);
        }

        .tabs-content__inner-list li .icon span {
            font-size: 65px;
            color: var(--thm-primary);
            line-height: 65px;
        }

        .tabs-content__inner-list li .text {
            margin-left: 20px;
        }

        .tabs-content__inner-list li .text h4 {
            font-size: 20px;
            font-weight: 700;
            line-height: 30px;
            margin-bottom: 10px;
        }

        .tabs-content__inner-list li .text p {
            margin: 0;
        }

        /*--------------------------------------------------------------
# Brand One
--------------------------------------------------------------*/
        .brand-one {
            position: relative;
            display: block;
            background-color: #ffffff;
            padding: 50px 0 50px;
            border-top: 1px solid var(--thm-clr-extra);
        }

        .brand-one .swiper-slide {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-align: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
        }

        .brand-one .swiper-slide img {
            -webkit-transition: 500ms;
            transition: 500ms;
            opacity: 0.3;
            max-width: 100%;
        }

        .brand-one .swiper-slide img:hover {
            opacity: 0.6;
        }

        /*--------------------------------------------------------------
# We Building
--------------------------------------------------------------*/
        .we-building {
            position: relative;
            display: block;
            padding: 120px 0 0px;
            z-index: 2;
        }

        .we-building-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center;
            z-index: -1;
        }

        .we-building-bg:before {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            content: "";
            background-color: rgba(var(--thm-black-rgb), .85);
            z-index: -1;
        }

        .we-building-bg.jarallax div div {
            filter: grayscale(100%);
        }

        .we-building__video-box {
            position: relative;
            display: block;
            margin-right: 70px;
            margin-top: 15px;
        }

        .we-building__video-link {
            position: relative;
            display: block;
            margin-left: 15px;
        }

        .we-building__video-icon {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100px;
            height: 100px;
            line-height: 100px;
            text-align: center;
            font-size: 20px;
            color: var(--thm-base);
            background-color: var(--thm-primary);
            border-radius: 0;
            transition: all 0.5s ease;
            -moz-transition: all 0.5s ease;
            -webkit-transition: all 0.5s ease;
            -ms-transition: all 0.5s ease;
            -o-transition: all 0.5s ease;
        }

        .we-building__video-icon:hover {
            background-color: #fff;
            color: var(--thm-black);
        }

        .we-building__video-icon:before {
            position: absolute;
            top: -15px;
            left: -15px;
            right: -15px;
            bottom: -15px;
            content: "";
            border: 1px solid #383838;
        }

        .we-building__video-icon span {}

        .we-building__video-link .ripple,
        .we-building__video-icon .ripple:before,
        .we-building__video-icon .ripple:after {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 130px;
            height: 130px;
            transform: translate(-50%, -50%);
            -ms-box-shadow: 0 0 0 0 rgba(var(--thm-primary-rgb), 0.6);
            -o-box-shadow: 0 0 0 0 rgba(var(--thm-primary-rgb), 0.6);
            box-shadow: 0 0 0 0 rgba(var(--thm-primary-rgb), 0.6);
            -webkit-animation: ripple 3s infinite;
            animation: ripple 3s infinite;
        }

        .we-building__video-icon .ripple:before {
            -webkit-animation-delay: 0.9s;
            animation-delay: 0.9s;
            content: "";
            position: absolute;
        }

        .we-building__video-icon .ripple:after {
            -webkit-animation-delay: 0.6s;
            animation-delay: 0.6s;
            content: "";
            position: absolute;
        }

        .we-building__video-title {
            font-size: 60px;
            color: var(--thm-base);
            font-weight: 700;
            line-height: 73px;
            margin-top: 40px;
        }

        .we-building__get-quote {
            position: relative;
            display: block;
            padding: 50px 50px 50px;
            background-color: var(--thm-base);
            margin-left: 67px;
        }

        .we-building__get-quote-title {
            font-size: 30px;
            font-weight: 700;
            line-height: 40px;
            margin-bottom: 20px;
            text-align: center;
        }

        .we-building__form {}

        .we-building__form input[type="text"],
        .we-building__form input[type="email"] {
            height: 75px;
            width: 100%;
            border: none;
            background-color: #f3f3f3;
            margin-bottom: 10px;
            color: var(--thm-gray);
            font-size: 14px;
            font-weight: 500;
            padding: 0 30px 0;
            outline: none;
        }

        .we-building__get-quote-btn {
            border: none;
            outline: none;
        }

        .we-building__get-quote-btn .btn-title {
            padding: 27px 80px 24px;
        }

        /*--------------------------------------------------------------
# Project One
--------------------------------------------------------------*/
        .project-one {
            position: relative;
            display: block;
            padding: 120px 0 170px;
        }

        .project-one .section-title {}

        .project-one__carousel {
            position: relative;
            display: block;
        }

        .project-one__single {
            position: relative;
            display: block;
        }

        .project-one__img {
            position: relative;
            display: block;
            overflow: hidden;
            z-index: 1;
        }

        .project-one__img:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: rgba(var(--thm-black-rgb), .40);
            transform: scaleX(0.0);
            transform-origin: center;
            transform-style: preserve-3d;
            -webkit-transition: all 0.4s linear;
            -o-transition: all 0.4s linear;
            transition: all 0.4s linear;
            z-index: 1;
        }

        .project-one__single:hover .project-one__img:before {
            transform: scaleX(1.0);
        }

        .project-one__img img {
            width: 100%;
            transition: all 500ms ease;
            transform: scale(1);
        }

        .project-one__single:hover .project-one__img img {
            transform: scale(1.05);
        }

        .project-one__content {
            position: absolute;
            bottom: 0;
            left: 0;
            background-color: var(--thm-base);
            padding-top: 28px;
            padding-bottom: 25px;
            padding-left: 40px;
            padding-right: 90px;
            transform: scaleY(0.0);
            transform-origin: center;
            transform-style: preserve-3d;
            -webkit-transition: all 0.4s linear;
            -o-transition: all 0.4s linear;
            transition: all 0.4s linear;
            transform-origin: bottom center;
            z-index: 2;
        }

        .project-one__single:hover .project-one__content {
            transform: scaleY(1.0);
        }

        .project-one__tagline {
            font-size: 10px;
            text-transform: uppercase;
            color: var(--thm-primary);
            line-height: 20px;
        }

        .project-one__tagline span {
            padding-right: 5px;
            padding-left: 5px;
        }

        .project-one__tilte {
            font-size: 26px;
            font-weight: 700;
            line-height: 36px;
        }

        .project-one__tilte>a {
            color: var(--thm-black);
            transition: all 500ms ease;
        }

        .project-one__tilte>a:hover {
            color: var(--thm-primary);
        }

        .project-one__arrow {
            position: absolute;
            top: -55px;
            right: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .project-one__arrow>a {
            position: relative;
            height: 55px;
            width: 55px;
            background-color: var(--thm-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: var(--thm-base);
            transition: all 500ms ease;
        }

        .project-one__arrow>a:hover {
            background-color: var(--thm-black);
        }

        .project-one__carousel.owl-carousel .owl-stage-outer {
            overflow: visible;
            padding: 0px 0px 0px;
        }

        .project-one__carousel.owl-carousel .owl-dots {
            position: absolute;
            bottom: -62px;
            right: 0px;
            left: 0;
            margin: 0 !important;
        }

        .project-one__carousel.owl-carousel .owl-dots .owl-dot {
            position: relative;
            display: inline-block;
            width: 10px;
            height: 10px;
            background: var(--thm-black);
            opacity: .4;
            margin: 0px 5px;
            padding: 0px;
            border-radius: 50%;
            transition: all 100ms linear;
            transition-delay: 0.1s;
        }

        .project-one__carousel.owl-carousel .owl-dot.active {
            opacity: 1;
            height: 13px;
            width: 13px;
        }

        .project-one__carousel.owl-carousel .owl-dot:focus {
            outline: none;
        }

        .project-one__carousel.owl-carousel .owl-dots .owl-dot span {
            display: none;
        }

        /*--------------------------------------------------------------
# Have Questions
--------------------------------------------------------------*/
        .have-questions {
            position: relative;
            display: block;
            padding: 0 0 120px;
        }

        .have-questions__left {
            position: relative;
            display: block;
            margin-right: 70px;
        }

        .have-questions__left .section-title {
            margin-bottom: 38px;
        }

        .have-questions__list {}

        .have-questions__list li {
            position: relative;
            display: flex;
            align-items: center;
        }

        .have-questions__list li+li {
            margin-top: 13px;
        }

        .have-questions__list li .icon {
            display: flex;
            align-items: center;
        }

        .have-questions__list li .icon span {
            color: var(--thm-primary);
            font-size: 16px;
        }

        .have-questions__list li .text {
            margin-left: 10px;
        }

        .have-questions__list li .text p {
            font-size: 18px;
            color: var(--thm-black);
            font-weight: 500;
            margin: 0;
        }

        .have-questions__img {
            position: relative;
            display: block;
            margin-top: 51px;
        }

        .have-questions__img::before {
            position: absolute;
            top: 50%;
            left: 50%;
            display: block;
            content: '';
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, .2);
            border-radius: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            opacity: 0;
            z-index: 10;
        }

        .have-questions__img:hover:before {
            -webkit-animation: circle .75s;
            animation: circle .75s;
        }

        .have-questions__img img {
            width: 100%;
        }


        .have-questions__right {
            position: relative;
            display: block;
            margin-left: -30px;
        }

        .faq-one-accrodion .accrodion {
            position: relative;
            display: block;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            border-radius: 0;
            background-color: #f3f3f3;
            border: 0px solid transparent;
        }

        .faq-one-accrodion .accrodion.active {
            border: 1px solid var(--thm-clr-extra);
            box-shadow: 0px 20px 20px 0px rgb(0, 0, 0, .03);
        }

        .faq-one-accrodion .accrodion:before {
            position: absolute;
            top: -1px;
            left: -1px;
            bottom: -1px;
            width: 4px;
            content: "";
            background-color: var(--thm-primary);
            transform: scaleY(0);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            z-index: 1;
        }

        .faq-one-accrodion .accrodion.active:before {
            transform: scaleY(1);
        }

        .faq-one-accrodion .accrodion-title {
            position: relative;
            display: block;
            cursor: pointer;
            padding: 26px 40px 26px;
            padding-right: 27px;
            transition: all 200ms linear;
            transition-delay: 0.1s;
            border-bottom: 0px solid var(--thm-extra);
        }

        .faq-one-accrodion .accrodion-title h4 {
            margin: 0;
            font-size: 18px;
            font-weight: 500;
            line-height: 28px;
            color: var(--thm-black);
            position: relative;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .faq-one-accrodion .accrodion+.accrodion {
            margin-top: 15px;
        }

        .faq-one-accrodion .accrodion.active .accrodion-title {
            background-color: var(--thm-base);
        }

        .faq-one-accrodion .accrodion.active .accrodion-title h4 {
            color: var(--thm-black);
        }

        .faq-one-accrodion .accrodion-title h4::before {
            content: "\f106";
            font-family: "Font Awesome 5 Free";
            font-weight: 900;
            font-size: 17px;
            color: var(--thm-black);
            ;
            position: absolute;
            top: 50%;
            right: 0;
            height: 35px;
            width: 35px;
            border-radius: 50%;
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
            -webkit-transform: translateY(-50%);
            transform: translateY(-50%);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .faq-one-accrodion .accrodion.active .accrodion-title h4::before {
            content: "\f107";
            color: var(--thm-primary);
            ;
            height: 35px;
            width: 35px;
            border-radius: 50%;
            text-align: center;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .faq-one-accrodion .accrodion-content {
            position: relative;
            padding: 0px 40px 26px;
        }

        .faq-one-accrodion .accrodion.active .accrodion-content {
            background-color: var(--thm-base);
        }

        .faq-one-accrodion .accrodion.last-chiled.active .accrodion-content {}

        .faq-one-accrodion .accrodion-content p {
            margin: 0;
        }

        /*--------------------------------------------------------------
# Testimonial One
--------------------------------------------------------------*/
        .testimonial-one {
            position: relative;
            display: block;
            padding: 120px 0 150px;
            background-color: #f3f3f3;
        }

        .testimonial-one-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
            opacity: 0.04;
            background-color: #f3f3f3;
            mix-blend-mode: luminosity;
        }

        .testimonial-one-bg-overly {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(243, 243, 243, .96);
            opacity: 0;
        }

        .testimonial-one__left {
            position: relative;
            display: block;
            z-index: 2;
        }

        .testimonial-one__left .section-title {}

        .testimonial-one__right {
            position: relative;
            display: block;
            margin-right: -450px;
        }

        .testimonial-one__carousel,
        .credential__carousel {
            position: relative;
            display: block;
        }

        .testimonial-one__carousel.owl-carousel .owl-stage-outer,
        .credential__carousel .owl-stage-outer {
            overflow: visible;
            padding: 0 0 0;
            margin-right: 0px;
        }

        .testimonial-one__carousel .owl-stage-outer .owl-item,
        .credential__carousel .owl-stage-outer .owl-item {
            opacity: 0;
            transition: all 500ms linear;
            transition-delay: 0.1s;
        }

        .testimonial-one__carousel .owl-stage-outer .owl-item.active,
        .credential__carousel .owl-stage-outer .owl-item.active {
            opacity: 1;
            transition: all 200ms linear;
        }

        .testimonial-one__carousel.owl-carousel .owl-dots,
        .credential__carousel.owl-carousel .owl-dots {
            position: absolute;
            bottom: -15px;
            left: -404px;
            margin: 0 !important;
        }

        .testimonial-one__carousel.owl-carousel .owl-dots .owl-dot,
        .credential__carousel.owl-carousel .owl-dots {
            position: relative;
            display: inline-block;
            width: 10px;
            height: 10px;
            background: var(--thm-black);
            opacity: .4;
            margin: 0px 5px;
            padding: 0px;
            border-radius: 50%;
            transition: all 100ms linear;
            transition-delay: 0.1s;
        }

        .testimonial-one__carousel.owl-carousel .owl-dot.active,
        .credential__carousel.owl-carousel .owl-dots.active {
            opacity: 1;
            height: 13px;
            width: 13px;
        }

        .testimonial-one__carousel.owl-carousel .owl-dot:focus,
        .credential__carousel.owl-carousel .owl-dots:focus {
            outline: none;
        }

        .testimonial-one__carousel.owl-carousel .owl-dots .owl-dot span,
        .credential__carousel.owl-carousel .owl-dots span {
            display: none;
        }

        .testimonial-one__single {
            position: relative;
            display: block;
            border: 1px solid transparent;
            padding: 50px 60px 56px;
            background-color: var(--thm-base);
            transition: all 500ms ease;
        }

        .testimonial-one__single:hover {
            border: 1px solid var(--thm-clr-extra);
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .05);
        }

        .testimonial-one__text {
            font-size: 18px;
            margin: 0;
            padding-bottom: 32px;
        }

        .testimonial-one__client-info {}

        .testimonial-one__client-name {
            font-size: 18px;
            color: var(--thm-primary);
            font-weight: 700;
            line-height: 28px;
            margin-bottom: 7px;
        }

        .testimonial-one__client-title {
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        .testimonial-one__client-img {
            position: absolute;
            bottom: -25px;
            right: 65px;
        }

        .testimonial-one__client-img:before {
            position: absolute;
            content: "";
            border: 2px solid var(--thm-primary);
            top: -7px;
            bottom: -7px;
            left: -7px;
            right: -7px;
        }

        .testimonial-one__client-img img {}

        /*--------------------------------------------------------------
# News One
--------------------------------------------------------------*/
        .news-one {
            position: relative;
            display: block;
            padding: 120px 0 90px;
        }

        .news-one .section-title {}

        .news-one__single {
            position: relative;
            display: block;
            margin-bottom: 30px;
        }

        .news-one__img-box {
            position: relative;
            display: block;
        }

        .news-one__img {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .news-one__img img {
            width: 100%;
            transform: scale(1);
            transition: all 500ms ease;
        }

        .news-one__single:hover .news-one__img img {
            transform: scale(1.05);
        }

        .news-one__img>a {
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(var(--thm-black-rgb), 0.4);
            position: absolute;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 30px;
            color: var(--thm-base);
            transition: opacity 500ms ease, visibility 500ms ease, transform 500ms ease;
            visibility: hidden;
            opacity: 0;
            transform: translateY(-30%);
            border-radius: var(--thm-border-radius);
        }

        .news-one__img>a>span {
            position: relative;
        }

        .news-one__img>a>span::before {
            content: '';
            width: 20px;
            height: 2px;
            background-color: var(--thm-base);
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            transition: all 500ms ease;
        }

        .news-one__img>a>span::after {
            content: '';
            transition: all 500ms ease;
            width: 2px;
            height: 20px;
            background-color: var(--thm-base);
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .news-one__img>a:hover>span::before,
        .news-one__img>a:hover>span::after {
            background-color: var(--thm-primary);
        }

        .news-one__single:hover .news-one__img>a {
            visibility: visible;
            transform: translateY(0%);
            opacity: 1;
        }

        .news-one__date {
            height: 70px;
            width: 70px;
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .10);
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            bottom: -20px;
            right: 20px;
            z-index: 2;
        }

        .news-one__date p {
            font-size: 14px;
            color: var(--thm-black);
            font-weight: 700;
            margin: 0;
            line-height: 20px;
            text-align: center;
            text-transform: uppercase;
        }

        .news-one__content {
            position: relative;
            display: block;
            border: 1px solid var(--thm-clr-extra);
            border-top: 0;
            background-color: var(--thm-base);
            padding: 20px 40px 26px;
            transition: all 500ms ease;
        }

        .news-one__single:hover .news-one__content {
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .07);
        }

        .news-one__meta {
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            margin: 0;
        }

        .news-one__meta li {}

        .news-one__meta li+li {
            margin-left: 15px;
        }

        .news-one__meta li a {
            font-size: 14px;
            color: var(--thm-gray);
        }

        .news-one__meta li a i {
            color: var(--thm-primary);
        }

        .news-one__title {
            font-size: 26px;
            color: var(--thm-black);
            line-height: 40px;
            font-weight: 700;
        }

        .news-one__title a {
            color: var(--thm-black);
            transition: all 500ms ease;
        }

        .news-one__title a:hover {
            color: var(--thm-primary);
        }

        .news-one__text {
            margin: 0;
            padding-top: 24px;
            padding-bottom: 10px;
        }

        .news-one__btn-box {
            position: relative;
            display: block;
        }

        .news-one__btn-box a {
            position: relative;
            display: inline-block;
            font-size: 12px;
            color: var(--thm-black);
            text-transform: uppercase;
            font-weight: 500;
            padding-left: 20px;
        }

        .news-one__btn-box a:before {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            content: "";
            width: 10px;
            height: 2px;
            background-color: var(--thm-black);
            left: 0;
            transition: all 500ms ease;
        }

        .news-one__single:hover .news-one__btn-box a:before {
            background-color: var(--thm-primary);
        }

        /*--------------------------------------------------------------
# CTA One
--------------------------------------------------------------*/
        .cta-one {
            position: relative;
            display: block;
            padding: 80px 0;
        }

        .cta-one-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center;
            z-index: -1;
        }

        .cta-one-bg:before {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            content: "";
            background-color: rgba(var(--thm-primary-rgb), .95);
            z-index: -1;
        }

        .cta-one-bg.jarallax div div {
            filter: grayscale(100%);
        }

        .cta-one__inner {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .cta-one__title {}

        .cta-one__title h2 {
            font-size: 50px;
            font-weight: 700;
            line-height: 60px;
            color: var(--thm-base);
        }

        .cta-one__btn-box {
            display: flex;
            align-items: center;
        }

        .cta-one__btn {
            background-color: var(--thm-black);
        }

        .cta-one__btn:hover {
            color: var(--thm-primary);
            background-color: var(--thm-black);

        }

        .cta-one__btn .btn-curve {
            background: rgba(var(--thm-base-rgb), .10);
        }

        .cta-one__btn:hover .btn-curve {
            background: rgba(var(--thm-base-rgb), 1);
        }

        /*--------------------------------------------------------------
# Site Footer
--------------------------------------------------------------*/
        .site-footer {
            position: relative;
            display: block;
        }

        .site-footer__top {
            position: relative;
            display: block;
            background-color: var(--thm-black);
        }

        .site-footer__top-inner {
            position: relative;
            display: block;
            padding: 112px 0 108px;
            z-index: 1;
        }

        .site-footer-map {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center;
            opacity: 0.05;
            z-index: -1;
        }

        .footer-widget__about {
            position: relative;
            display: block;
            margin-top: 5px;
        }

        .footer-widget__about-logo {}

        .footer-widget__about-logo a {}

        .footer-widget__about-text {
            font-size: 24px;
            color: var(--thm-base);
            margin: 0;
            padding-top: 30px;
            padding-bottom: 20px;
        }

        .footer-widget__about-social {
            position: relative;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
        }

        .footer-widget__about-social a {
            position: relative;
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: #aeaeae;
            background-color: #000000;
            border-radius: 50%;
            font-size: 13px;
            height: 45px;
            width: 45px;
            transform: rotate(0);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            z-index: 1;
        }

        .footer-widget__about-social a:hover {
            color: var(--thm-black);
            transform: rotate(360deg);
        }

        .footer-widget__about-social a:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: var(--thm-base);
            border-radius: 50%;
            transform: scale(0.0);
            transform-origin: center;
            transform-style: preserve-3d;
            transition: all 0.4s cubic-bezier(0.62, 0.21, 0.45, 1.52);
            z-index: -1;
        }

        .footer-widget__about-social a:hover:before {
            transform: scaleX(1.0);
        }

        .footer-widget__about-social a+a {
            margin-left: 10px;
        }

        .footer-widget__title {
            font-size: 20px;
            color: var(--thm-base);
            font-weight: 700;
            line-height: 30px;
            margin-bottom: 21px;
        }

        .footer-widget__links {
            position: relative;
            display: block;
        }

        .footer-widget__links-list {
            position: relative;
            display: block;
        }

        .footer-widget__links-list li+li {
            margin-top: 5px;
        }

        .footer-widget__links-list li a {
            position: relative;
            display: inline-block;
            font-size: 14px;
            font-weight: 500;
            color: #aeaeae;
            transition: all 500ms ease;
        }

        .footer-widget__links-list li a:hover {
            padding-left: 20px;
            color: var(--thm-base);
        }

        .footer-widget__links-list li a:before {
            position: absolute;
            top: 50%;
            left: 0;
            bottom: 0;
            width: 10px;
            height: 2px;
            content: "";
            background-color: var(--thm-primary);
            transform: translateY(-50%);
            opacity: 0;
            transition: all 500ms ease;
        }

        .footer-widget__links-list li a:hover:before {
            opacity: 1;
        }


        .footer-widget__contact {
            position: relative;
            display: block;
        }

        .footer-widget__contact-list {
            position: relative;
            display: block;
        }

        .footer-widget__contact-list li {
            display: flex;
        }

        .footer-widget__contact-list li+li {
            margin-top: 12px;
        }

        .footer-widget__contact-list li .icon {}

        .footer-widget__contact-list li .icon span {
            font-size: 15px;
            color: var(--thm-primary);
        }

        .footer-widget__contact-list li .text {
            margin-left: 10px;
        }

        .footer-widget__contact-list li .text p {
            font-size: 14px;
            color: #aeaeae;
            font-weight: 500;
            margin: 0;
            line-height: 30px;
        }

        .footer-widget__contact-list li .text p a {
            font-size: 14px;
            color: #aeaeae;
            font-weight: 500;
            transition: all 500ms ease;
        }

        .footer-widget__contact-list li .text p a:hover {
            color: var(--thm-base);
        }

        .footer-widget__newsletter {
            position: relative;
            display: block;
        }

        .footer-widget__newsletter-text {
            font-size: 14px;
            color: #aeaeae;
            font-weight: 500;
            line-height: 32px;
            margin: 0;
        }

        .footer-widget__newsletter-form {
            position: relative;
            display: block;
        }

        .footer-widget__newsletter-input-box {
            position: relative;
            display: block;
        }

        .footer-widget__newsletter-input-box:before {
            position: absolute;
            bottom: 6px;
            left: 0;
            right: 0;
            content: "";
            height: 3px;
            background-color: rgba(var(--thm-base-rgb), .10);
            border-radius: 0;
        }

        .footer-widget__newsletter-input-box input[type="email"] {
            font-size: 14px;
            color: var(--thm-base);
            font-weight: 500;
            text-transform: capitalize;
            height: 70px;
            width: 100%;
            background: transparent;
            border: none;
            border-radius: 0;
            padding-right: 60px;
            outline: none;
        }

        .footer-widget__newsletter-btn {
            position: absolute;
            top: 50%;
            right: 0;
            height: 70px;
            width: 60px;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            border-radius: 50%;
            background: transparent;
            border: 0;
            transform: translateY(-50%);
            transition: all 500ms ease;
            padding: 0;
        }

        .footer-widget__newsletter-btn i {
            font-size: 15px;
            color: var(--thm-primary);
        }

        .footer-widget__newsletter-bottom {
            display: flex;
            align-items: center;
            margin-top: 6px;
            cursor: pointer;
        }

        .footer-widget__newsletter-bottom-icon {
            height: 18px;
            width: 18px;
            border: 1px solid #69696f;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .footer-widget__newsletter-bottom-icon i {
            font-size: 8px;
            color: #69696f;
        }

        .footer-widget__newsletter-bottom-text {
            margin-left: 10px;
        }

        .footer-widget__newsletter-bottom-text p {
            font-size: 14px;
            margin: 0;
            color: #aeaeae;
            font-weight: 500;
        }

        .site-footer__bottom {
            position: relative;
            display: block;
            background-color: #000000;
            padding: 27px 0 24px;
        }

        .site-footer__bottom-inner {
            position: relative;
            display: block;
            text-align: center;
        }

        .site-footer__bottom-text {
            font-size: 14px;
            font-weight: 500;
            color: #aeaeae;
            margin: 0;
        }

        .site-footer__bottom-text a {
            color: #aeaeae;
            transition: all 500ms ease;
        }

        .site-footer__bottom-text a:hover {
            color: var(--thm-base);
        }

        /*--------------------------------------------------------------
# Three Icon
--------------------------------------------------------------*/
        .three-icon {
            position: relative;
            display: block;
        }

        .three-icon-container {
            position: relative;
            display: block;
            width: 100%;
            margin: 0 auto;
        }

        .three-icon-container .row {
            --bs-gutter-x: 0px;
        }

        .three-icon__single {
            position: relative;
            display: flex;
            align-items: center;
            background-color: rgb(243, 243, 243);
            box-shadow: 0px 1px 0px 0px rgb(227, 227, 227, .100);
            padding: 48px 150px 47px;
            padding-right: 70px;
            border-bottom: 1px solid var(--thm-clr-extra);
            transition: all 500ms ease;
            z-index: 1;
        }

        .three-icon__single:after {
            position: absolute;
            top: 0;
            bottom: 0;
            right: 0;
            content: "";
            width: 1px;
            background-color: var(--thm-clr-extra);
        }

        .three-icon__single:hover {
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 1px 0px 0px rgb(227, 227, 227, .100);
        }

        .three-icon__single:before {
            position: absolute;
            bottom: -1px;
            left: -1px;
            right: -1px;
            height: 4px;
            width: 0%;
            content: "";
            background-color: var(--thm-primary);
            transition: all 500ms ease;
            z-index: 2;
        }

        .three-icon__single:hover:before {
            width: 100%;
        }

        .three-icon__icon {
            display: flex;
            align-items: center;
        }

        .three-icon__icon span {
            font-size: 70px;
            color: var(--thm-primary);
        }

        .three-icon__text {
            margin-left: 30px;
        }

        .three-icon__tagline {
            margin: 0;
            padding-bottom: 18px;
        }

        .three-icon__title {
            font-size: 24px;
            font-weight: 700;
            line-height: 37px;
        }

        .three-icon__single-1 {}

        .three-icon__single-2 {
            border-left: 0;
            border-right: 0;
        }

        .three-icon__single-3 {}

        /*--------------------------------------------------------------
# Welcome Two
--------------------------------------------------------------*/
        .welcome-two {
            position: relative;
            display: block;
            padding: 120px 0 107px;
        }

        .welcome-two__left {
            position: relative;
            display: block;
            margin-right: 70px;
        }

        .welcome-two__left .section-title {}

        .welcome-two__check {
            position: relative;
            display: flex;
            align-items: center;
            background-color: #f6f6f6;
            padding-left: 30px;
            padding-top: 17px;
            padding-bottom: 17px;
        }

        .welcome-two__check-icon {
            display: flex;
        }

        .welcome-two__check-icon span {
            font-size: 16px;
            color: var(--thm-primary);
        }

        .welcome-two__check-text-box {
            margin-left: 20px;
        }

        .welcome-two__check-text {
            font-size: 18px;
            color: var(--thm-black);
            font-weight: 500;
            line-height: 28px;
            margin: 0;
        }

        .welcome-two__text {
            font-size: 18px;
            margin: 0;
            padding-top: 50px;
            padding-bottom: 39px;
        }

        .progress-levels {
            position: relative;
            display: block;
        }

        .progress-levels .progress-box {
            position: relative;
            display: block;
            margin-bottom: 20px;
        }

        .progress-levels .progress-box.last-child {
            margin-bottom: 0;
        }

        .progress-levels .progress-box .inner {
            position: relative;
            display: block;
        }

        .progress-levels .progress-box .bar {
            position: relative;
            display: block;
        }

        .progress-levels .progress-box .bar .bar-innner {
            position: relative;
            width: 100%;
            height: 7px;
            background: #f3f3f3;
            border-radius: 0px;
        }

        .progress-levels .progress-box .bar .bar-fill {
            position: absolute;
            top: 0%;
            left: 0px;
            bottom: 0%;
            width: 0px;
            height: 7px;
            border-radius: 0px;
            background: var(--thm-primary);
            transition: all 2000ms ease 300ms;
        }

        .progress-levels .progress-box .bar .bar-innner .skill-percent {
            position: absolute;
            top: -37px;
            right: 0;
            width: 40px;
            height: 25px;
            display: block;
            text-align: center;
            padding: 0;
            z-index: 1;
        }

        .progress-levels .progress-box .inner .count-text {
            position: relative;
            color: var(--thm-gray);
            font-size: 14px;
            line-height: 20px;
            font-weight: 500;
            display: inline-block;
            float: none;
        }

        .progress-levels .progress-box .inner .percent {
            position: relative;
            color: var(--thm-gray);
            font-size: 14px;
            line-height: 20px;
            font-weight: 500;
            display: inline-block;
            float: none;
            margin-left: -2px;
        }

        .progress-levels .progress-box .inner .text {
            position: relative;
            color: var(--thm-black);
            font-size: 18px;
            font-weight: 500;
            text-transform: capitalize;
            padding-bottom: 6px;
        }

        .progress-levels .progress-box-last {
            margin-bottom: 0px;
        }

        .welcome-two__left-bottom {
            position: relative;
            display: flex;
            align-items: center;
            margin-top: 60px;
        }

        .welcome-two__left-btn-box {
            display: flex;
            align-items: center;
        }

        .welcome-two__left-btn {
            background: var(--thm-black);
        }

        .welcome-two__left-btn:hover {
            background: var(--thm-black);
            color: var(--thm-base);
        }

        .welcome-two__left-btn .btn-curve {
            background: rgba(var(--thm-base-rgb), .10);
        }

        .welcome-two__left-btn:hover .btn-curve {
            background: rgba(var(--thm-primary-rgb), 1);
        }

        .welcome-two__left-video-box {
            position: relative;
            display: flex;
            align-items: center;
            margin-left: 20px;
        }

        .welcome-two__left-video-link {
            position: relative;
            height: 75px;
            width: 75px;
            border: 1px solid var(--thm-clr-extra);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            z-index: 1;
        }

        .welcome-two__left-video-img-box {
            position: absolute;
            top: 8px;
            left: 8px;
            right: 8px;
            bottom: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1;
        }

        .welcome-two__left-video-img-box img {}

        .welcome-two__left-video-btn {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1;
        }

        .welcome-two__left-video-icon {
            font-size: 15px;
            color: var(--thm-primary);
            z-index: 2;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: 8px;
            left: 8px;
            right: 8px;
            bottom: 8px;
        }

        .welcome-two__left-video-icon:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: var(--thm-black);
            border-radius: 50%;
            transform: scale(0);
            transition: all 500ms ease;
            z-index: -1;
        }

        .welcome-two__left-video-icon:hover:before {
            transform: scale(1);
        }

        .welcome-two__left-video-icon span {}

        .welcome-two__left-video-text {
            margin-left: 8px;
        }

        .welcome-two__left-video-text h3 {
            font-size: 23px;
            font-weight: 400;
            font-family: var(--thm-reey-font);
            line-height: 34px;
        }

        .welcome-two__right {
            position: relative;
            display: block;
            margin-right: 70px;
        }

        .welcome-two__right-img-box {
            position: relative;
            display: block;
        }

        .welcome-two__right-img-box:before {
            position: absolute;
            top: 80px;
            left: 0;
            right: -1000000000000px;
            bottom: 80px;
            background-color: #f3f3f3;
            content: "";
        }

        .welcome-two__right-img {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .welcome-two__right-img:before {
            position: absolute;
            top: 0;
            left: -100%;
            display: block;
            content: '';
            width: 50%;
            height: 100%;
            background: linear-gradient(to right, rgba(255, 255, 255, 0) 0%, rgba(255, 255, 255, .3) 100%);
            transform: skewX(-25deg);
            z-index: 1;
        }

        .welcome-two__right-img-box:hover .welcome-two__right-img:before {
            -webkit-animation: shine 1.5s;
            animation: shine 1.5s;
        }

        .welcome-two__right-img img {
            width: 100%;
        }

        .welcome-two__trusted {
            height: 175px;
            width: 175px;
            border-radius: 50%;
            position: absolute;
            right: 35px;
            bottom: 235px;
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 0px 40px 0px rgb(0, 0, 0, .05);
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            z-index: 3;
        }

        .welcome-two__trusted:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-image: url(../images/shapes/welcome-two-trasted-shape.png);
            background-repeat: no-repeat;
            background-position: center;
            opacity: .2;
        }

        .welcome-two__trusted h3 {
            font-size: 12px;
            font-weight: 400;
            color: var(--thm-gray);
            font-family: var(--thm-font);
            letter-spacing: 0.2em;
            text-transform: uppercase;
        }

        .welcome-two__trusted h3 span {
            font-size: 40px;
            color: var(--thm-primary);
            line-height: 50px !important;
            font-family: var(--thm-font) !important;
            letter-spacing: 0;
            font-weight: 400;
        }

        .welcome-two__right-small-img {
            position: absolute;
            bottom: 0;
            right: -190px;
            z-index: 2;
        }

        .welcome-two__right-small-img img {}

        /*--------------------------------------------------------------
# Services Two
--------------------------------------------------------------*/
        .services-two {
            padding-bottom: 90px;
            padding-top: 120px;
        }

        .services-two:before {
            top: 0;
        }

        /*--------------------------------------------------------------
# Team One
--------------------------------------------------------------*/
        .team-one {
            position: relative;
            display: block;
            padding: 0 0 90px;
        }

        .team-one__container {
            position: relative;
            display: block;
            max-width: 1700px;
            width: 100%;
            margin: 0 auto;
            padding: 0 15px 0;
        }

        .team-one__container .section-title {}

        .team-one__single {
            position: relative;
            display: block;
            text-align: center;
            margin-bottom: 30px;
        }

        .team-one__img {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .team-one__img:before {
            position: absolute;
            content: "";
            bottom: 0;
            left: 0;
            right: 0;
            height: 100%;
            background-color: rgba(var(--thm-black-rgb), .40);
            transition-delay: .1s;
            transition-timing-function: ease-in-out;
            transition-duration: .5s;
            transition-property: all;
            transform-origin: bottom;
            transform-style: preserve-3d;
            transform: scaleY(0);
            z-index: 1;
        }

        .team-one__single:hover .team-one__img:before {
            transform: scaleY(1.0);
        }

        .team-one__img img {
            width: 100%;
            transition: all 200ms linear;
            transition-delay: 0.1s;
        }

        .team-one__single:hover .team-one__img img {
            transform: scale(1.2);
            transition: all 0.5s cubic-bezier(0.62, 0.21, 0.45, 1.52);
        }

        .team-one__social {
            position: absolute;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            bottom: 30px;
            left: 50%;
            opacity: 0;
            -webkit-transition: .5s;
            -o-transition: .5s;
            transition: .5s;
            -webkit-transform: perspective(400px) rotateX(90deg) translateX(-50%);
            -ms-transform: perspective(400px) rotateX(90deg) translateX(-50%);
            transform: perspective(400px) rotateX(90deg) translateX(-50%);
            -webkit-transform-origin: bottom;
            -ms-transform-origin: bottom;
            transform-origin: bottom;
            z-index: 2;
        }

        .team-one__single:hover .team-one__social {
            opacity: 1.0;
            -webkit-transform: perspective(400px) rotateX(0deg) translateX(-50%);
            -ms-transform: perspective(400px) rotateX(0deg) translateX(-50%);
            transform: perspective(400px) rotateX(0deg) translateX(-50%);
        }

        .team-one__social a {
            position: relative;
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: #aeaeae;
            background-color: #000000;
            border-radius: 50%;
            font-size: 13px;
            height: 45px;
            width: 45px;
            transform: rotate(0);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            z-index: 1;
        }

        .team-one__social a+a {
            margin-left: 10px;
        }

        .team-one__social a:hover {
            color: var(--thm-base);
            transform: rotate(360deg);
            background-color: var(--thm-primary);
        }

        .team-one__social a:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: var(--thm-primary);
            border-radius: 50%;
            transform: scale(0.0);
            transform-origin: center;
            transform-style: preserve-3d;
            transition: all 0.4s cubic-bezier(0.62, 0.21, 0.45, 1.52);
            z-index: -1;
        }

        .team-one__social a:hover:before {
            transform: scaleX(1.0);
        }

        .team-one__content {
            position: relative;
            display: block;
            border-bottom: 1px solid var(--thm-clr-extra);
            padding-top: 22px;
            padding-bottom: 18px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .team-one__single:hover .team-one__content {
            border-bottom: 1px solid var(--thm-black);
        }

        .team-one__name {
            font-size: 24px;
            font-weight: 700;
            line-height: 34px;
        }

        .team-one__title {
            font-size: 15px;
            margin: 0;
        }

        /*--------------------------------------------------------------
# We Building Two
--------------------------------------------------------------*/
        .we-building-two {
            position: relative;
            display: block;
            padding: 120px 0 115px;
        }

        .we-building-two-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center;
            z-index: -1;
        }

        .we-building-two-bg:before {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            content: "";
            background-color: rgba(var(--thm-black-rgb), .85);
            z-index: -1;
        }

        .we-building-two-bg.jarallax div div {
            filter: grayscale(100%);
        }

        .we-building-two__inner {
            position: relative;
            display: block;
            text-align: center;
        }

        .we-building-two__inner .video-popup {
            width: 100px;
            height: 100px;
            margin-left: auto;
            margin-right: auto;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .we-building-two__inner .we-building__video-icon {
            margin: 0 auto;
        }

        .we-building-two__inner .we-building__video-title {
            margin-top: 63px;
        }

        /*--------------------------------------------------------------
# We Build
--------------------------------------------------------------*/
        .we-build {
            position: relative;
            display: block;
        }

        .we-build__left {
            position: relative;
            display: block;
            margin-right: 70px;
        }

        .we-build__img {
            position: relative;
            display: block;
            margin-left: -375px;
            overflow: hidden;
        }

        .we-build__img:before {
            position: absolute;
            top: 50%;
            left: 50%;
            display: block;
            content: '';
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, .2);
            border-radius: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            opacity: 0;
            z-index: 10;
        }

        .we-build__img:hover:before {
            -webkit-animation: circle .75s;
            animation: circle .75s;
        }

        .we-build__img img {
            width: 100%;
        }

        .we-build__dedicated {
            position: absolute;
            bottom: 60px;
            right: 60px;
            display: flex;
            align-items: center;
            background-color: var(--thm-base);
            padding: 35px 60px;
        }

        .we-build__dedicated:before {
            position: absolute;
            top: -6px;
            left: 0;
            right: 0;
            height: 6px;
            content: "";
            background-color: var(--thm-primary);
        }

        .we-build__dedicated-icon {
            display: flex;
            align-items: center;
        }

        .we-build__dedicated-icon span {
            font-size: 65px;
            color: var(--thm-black);
        }

        .we-build__dedicated__text {
            margin-left: 30px;
        }

        .we-build__dedicated__text h3 {
            font-size: 20px;
            font-weight: 700;
            line-height: 34px;
        }

        .we-build__right {
            position: relative;
            display: block;
            margin-top: 120px;
        }

        .we-build__right .section-title {
            margin-bottom: 39px;
        }

        .we-build__points {
            position: relative;
            display: block;
        }

        .we-build__points li {
            position: relative;
            display: block;
            padding-left: 86px;
            border-bottom: 1px solid #e2e2e2;
            padding-bottom: 42px;
            margin-bottom: 44px;
        }

        .we-build__points li:last-child {
            border-bottom: 0;
            padding-bottom: 0;
            margin-bottom: 0;
        }

        .we-build__points li .icon {
            height: 57px;
            width: 57px;
            background-color: rgba(var(--thm-primary-rgb), .10);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            color: var(--thm-primary);
            position: absolute;
            top: 8px;
            left: 0;
            transition: all 500ms ease;
        }

        .we-build__points li .icon:hover {
            background-color: rgba(var(--thm-primary-rgb), 1);
            color: var(--thm-base);
        }

        .we-build__points li .icon span {}

        .we-build__points li .text {}

        .we-build__points li .text h4 {
            font-size: 20px;
            font-weight: 700;
            line-height: 30px;
        }

        .we-build__points li .text p {
            margin: 0;
            line-height: 30px;
            padding-top: 12px;
        }

        /*--------------------------------------------------------------
# Project Two
--------------------------------------------------------------*/
        .project-two {
            position: relative;
            display: block;
            padding: 120px 0 0px;
            z-index: 3;
        }

        .project-two .section-title {}

        .project-two .project-one__single {
            margin-bottom: 30px;
        }

        .project-two .project-one__content {
            padding-right: 40px;
        }

        /*--------------------------------------------------------------
# Counter One
--------------------------------------------------------------*/
        .counters-one {
            position: relative;
            display: block;
            padding: 230px 0 86px;
            margin-top: -140px;
        }

        .counters-one-bg {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center center;
            z-index: -1;
        }

        .counters-one-bg:before {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            content: "";
            background-color: rgba(var(--thm-primary-rgb), .96);
            z-index: -1;
        }

        .counters-one-bg.jarallax div div {
            filter: grayscale(100%);
        }

        .counters-one__box {
            position: relative;
            display: block;
        }

        .counter-one__single {
            position: relative;
            display: inline-block;
            max-width: 289px;
            width: 100%;
            margin-bottom: 30px;
            padding-left: 130px;
        }

        .counter-one__single:before {
            position: absolute;
            top: 1px;
            left: 0px;
            bottom: 5px;
            content: "";
            width: 1px;
            background-color: rgba(var(--thm-base-rgb), .4);
        }

        .counter-one__single:nth-child(1) {
            padding-left: 40px;
        }

        .counter-one__single:nth-child(2) {
            padding-left: 70px;
        }

        .counter-one__single:nth-child(3) {
            padding-left: 117px;
        }

        .counter-one__single:nth-child(4) {
            padding-right: 0;
            padding-left: 137px;
        }

        .counter-one__single:nth-child(1):before {}

        .counter-one__single:nth-child(2):before {
            left: 19px;
        }

        .counter-one__single:nth-child(3):before {
            left: 66px;
        }

        .counter-one__single:nth-child(4):before {
            left: 86px;
        }

        .counter-one__icon {
            position: relative;
            height: 100px;
            width: 100px;
            color: var(--thm-base);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1;
        }

        .counter-one__icon:before {
            position: absolute;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            content: "";
            background-color: rgba(var(--thm-black-rgb), .10);
            transition: all 500ms ease;
            z-index: -1;
        }

        .counter-one__single:hover .counter-one__icon:before {
            background-color: rgba(var(--thm-black-rgb), 1);
        }

        .counter-one__icon span {
            position: relative;
            display: inline-block;
            font-size: 65px;
            color: var(--thm-base);
            line-height: 65px;
            transition: transform 500ms linear;
            transform: scale(1);
        }

        .counter-one__single:hover .counter-one__icon span {
            transform: scale(.85);
        }

        .counter-one__single h3 {
            font-size: 50px;
            color: var(--thm-base);
            font-weight: 400;
            line-height: 45px !important;
            margin-top: 24px;
            margin-bottom: 6px;
            font-family: var(--thm-font) !important;
        }

        .counter-one__text {
            font-size: 18px;
            font-weight: 500;
            margin: 0;
            line-height: 28px;
            color: var(--thm-base);
        }

        .counter-one__single .odometer-formatting-mark {
            display: none;
        }

        /*--------------------------------------------------------------
# Blog Two
--------------------------------------------------------------*/
        .news-two {
            position: relative;
            display: block;
            padding: 120px 0 210px;
        }

        .news-two__top {
            position: relative;
            display: flex;
            justify-content: space-between;
        }

        .news-two__top .section-title {}

        .news-two__top-btn-box {}

        .news-two__top-btn {}

        .news-two__content {
            position: relative;
            display: block;
            background-color: #f3f3f3;
            padding: 40px 50px 42px;
            margin-bottom: 30px;
        }

        .news-two__single-box {
            position: relative;
            display: block;
            border-bottom: 1px solid var(--thm-base);
            padding-bottom: 39px;
            margin-bottom: 36px;
        }

        .news-two__single-box-3 {
            border-bottom: 0;
            padding-bottom: 0px;
            margin-bottom: 0px;
        }

        /*--------------------------------------------------------------
# Call
--------------------------------------------------------------*/
        .call {
            position: relative;
            display: block;
            margin-top: -120px;
            z-index: 1;
        }

        .call__inner {
            position: relative;
            display: flex;
            align-items: center;
        }

        .call__img {
            position: relative;
            display: inline-block;
        }

        .call__img img {}

        .call__icon {
            height: 100px;
            width: 100px;
            background-color: var(--thm-primary);
            color: var(--thm-base);
            font-size: 45px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            right: -50px;
            transition: all 500ms ease;
            z-index: 2;
        }

        .call__icon:hover {
            background-color: var(--thm-black);
        }

        .call__icon span {}

        .call__content {
            position: relative;
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .05);
            border: 1px solid var(--thm-clr-extra);
            border-left: 0;
            display: flex;
            align-items: center;
            padding-left: 88px;
            padding-right: 50px;
            padding-top: 66px;
            padding-bottom: 62px;
        }

        .call__content-left p {
            font-size: 22px;
            color: var(--thm-black);
            margin: 0;
            padding-bottom: 9px;
        }

        .call__content-left a {
            font-size: 30px;
            color: var(--thm-primary);
            font-weight: 500;
            transition: all 500ms ease;
        }

        .call__content-left a:hover {
            color: var(--thm-black);
        }

        .call__content-text {
            position: relative;
            display: block;
            max-width: 325px;
            width: 100%;
            margin-left: 90px;
        }

        .call__content-text p {
            margin: 0;
        }

        /*--------------------------------------------------------------
# Google Map
--------------------------------------------------------------*/
        .google-map {
            position: relative;
            display: block;
            margin-top: -112px;
        }

        .google-map__one {
            position: relative;
            display: block;
            border: none;
            height: 560px;
            width: 100%;
        }

        /*--------------------------------------------------------------
# Page Header
--------------------------------------------------------------*/
        .page-header {
            position: relative;
            display: block;
            padding: 400px 0 0 0;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .page-header:before {
            position: absolute;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            content: "";
            /* background: rgba(var(--thm-black-rgb), .60); */
        }

        .page-header__inner {
            position: relative;
            display: block;
        }

        .page-header__inner h2 {
            font-size: 50px;
            color: var(--thm-base);
            line-height: 52px;
            font-weight: 900;
        }

        .thm-breadcrumb {
            padding-top: 5px;
        }

        .thm-breadcrumb li {
            position: relative;
            display: inline-block;
            color: var(--thm-base);
            font-size: 12px;
            text-transform: uppercase;
            font-weight: 700;
            letter-spacing: 0.1em;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .thm-breadcrumb li+li {
            margin-left: 11px;
        }

        .thm-breadcrumb li a {
            color: var(--thm-base);
            font-size: 12px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .thm-breadcrumb li:hover {
            color: var(--thm-primary);
        }

        .thm-breadcrumb li:hover a {
            color: var(--thm-primary);
        }

        .thm-breadcrumb li span {}

        /*--------------------------------------------------------------
# News Sidebar
--------------------------------------------------------------*/
        .news-sidebar {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .news-sidebar__left {
            position: relative;
            display: block;
        }

        .news-sidebar__content {
            position: relative;
            display: block;
        }

        .news-sidebar__content-single {
            position: relative;
            display: block;
            margin-bottom: 17px;
        }

        .news-sidebar__content-img {
            position: relative;
            display: block;
        }

        .news-sidebar__content-img img {
            width: 100%;
        }

        .news-sidebar__content-box {
            position: relative;
            display: block;
            margin-top: 20px;
        }

        .news-sidebar__meta {
            display: flex;
            -webkit-box-align: center;
            align-items: center;
        }

        .news-sidebar__meta li {}

        .news-sidebar__meta li+li {
            margin-left: 15px;
        }

        .news-sidebar__meta li a {
            font-size: 14px;
            color: var(--thm-gray);
            font-weight: 400;
            transition: all 500ms ease;
        }

        .news-sidebar__meta li a:hover {
            color: var(--thm-primary);
        }

        .news-sidebar__meta li a i {
            color: var(--thm-primary);
        }

        .news-sidebar__title {
            font-size: 30px;
            font-weight: 700;
            line-height: 40px;
            margin-bottom: 20px;
        }

        .news-sidebar__title a {
            color: var(--thm-black);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .news-sidebar__title a:hover {
            color: var(--thm-primary);
        }

        .news-sidebar__text {
            margin: 0;
        }

        .news-sidebar__read-more-btn {
            position: relative;
            display: inline-block;
            margin-top: 5px;
        }

        .news-sidebar__read-more-btn a {
            position: relative;
            display: inline-block;
            font-size: 12px;
            color: var(--thm-black);
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            padding-left: 20px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .news-sidebar__read-more-btn a:before {
            position: absolute;
            top: 50%;
            left: 0;
            height: 2px;
            width: 10px;
            background-color: var(--thm-black);
            content: "";
            transform: translateY(-50%);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .news-sidebar__read-more-btn a:hover {
            color: var(--thm-primary);
        }

        .news-sidebar__read-more-btn a:hover:before {
            background-color: var(--thm-primary);
        }

        .news-sidebar__bottom-box {
            position: relative;
            display: block;
            background-color: #f3f3f3;
            padding: 60px 60px 50px;
        }

        .news-sidebar__bottom-box-icon {
            margin-bottom: 19px;
        }

        .news-sidebar__bottom-box-icon>img {
            width: 59px;
        }

        .news-sidebar__bottom-box-text {
            font-size: 18px;
            margin: 0;
        }

        .news-sidebar__delivering-services {
            position: relative;
            display: block;
            background-color: #f3f3f3;
            padding: 60px 60px 54px;
            margin-top: 30px;
        }

        .news-sidebar__delivering-services-icon {}

        .blog-single__delivering-services-icon>img {
            width: 37px;
        }

        .news-sidebar__delivering-services-title {
            font-size: 30px;
            font-weight: 700;
            line-height: 40px;
            margin-top: 21px;
        }

        .news-sidebar__delivering-services-title a {
            color: var(--thm-black);
            transition: all 500ms ease;
        }

        .news-sidebar__delivering-services-title a:hover {
            color: var(--thm-primary);
        }

        .news-sidebar__video-btn {
            position: absolute;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 107px;
            height: 107px;
            text-align: center;
            font-size: 27px;
            color: var(--thm-base);
            background-color: var(--thm-primary);
            border-radius: 50%;
            top: 50%;
            left: 50%;
            right: 0;
            bottom: 0;
            transform: translateX(-50%) translateY(-50%);
            transition: all 500ms ease;
        }

        .news-sidebar__video-btn:hover {
            color: var(--thm-primary);
            background-color: var(--thm-base);
        }

        .news-sidebar__video-btn span {}

        /*--------------------------------------------------------------
# Sidebar
--------------------------------------------------------------*/

        @media (max-width: 991px) {
            .sidebar {
                margin-top: 50px;
            }
        }

        .sidebar__single+.sidebar__single {
            margin-top: 30px;
        }

        .sidebar__title {
            margin: 0;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 16px;
        }

        .sidebar__search {
            position: relative;
            display: block;
        }

        .sidebar__search-form {
            position: relative;
        }

        .sidebar__search-form input[type="search"] {
            display: block;
            border: none;
            outline: none;
            background-color: var(--thm-primary);
            color: var(--thm-base);
            font-size: 16px;
            font-weight: 700;
            padding-left: 50px;
            height: 84px;
            border-radius: var(--thm-border-radius);
            width: 100%;
            padding-right: 80px;
        }

        .sidebar__search-form ::-webkit-input-placeholder {
            color: var(--thm-base);
            opacity: 1;
        }

        .sidebar__search-form ::-moz-placeholder {
            color: var(--thm-base);
            opacity: 1;
        }

        .sidebar__search-form :-ms-input-placeholder {
            color: var(--thm-base);
            opacity: 1;
        }

        .sidebar__search-form ::-ms-input-placeholder {
            color: var(--thm-base);
            opacity: 1;
        }

        .sidebar__search-form ::placeholder {
            color: var(--thm-base);
            opacity: 1;
        }

        .sidebar__search-form :-ms-input-placeholder {
            color: var(--thm-base);
        }

        .sidebar__search-form ::-ms-input-placeholder {
            color: var(--thm-base);
        }

        .sidebar__search-form button[type="submit"] {
            background-color: transparent;
            color: var(--thm-base);
            font-size: 22px;
            position: absolute;
            top: 0;
            right: 18px;
            bottom: 0;
            width: 60px;
            outline: none;
            border: none;
            display: flex;
            align-items: center;
        }

        .sidebar__post {
            position: relative;
            display: block;
            padding: 45px 50px 47px;
            background-color: #f3f3f3;
        }

        .sidebar__post-list {
            margin: 0;
        }

        .sidebar__post-list li {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
        }

        .sidebar__post-list li+li {
            margin-top: 16px;
        }

        .sidebar__post-image {
            margin-right: 20px;
        }

        .sidebar__post-image>img {
            width: 60px;
        }

        .sidebar__post-content h3 {
            font-size: 18px;
            font-weight: 700;
            margin: 0;
            line-height: 26px;
        }

        .sidebar__post-content_meta {
            font-size: 14px;
            font-weight: 400;
            color: var(--thm-gray);
            display: block;
        }

        .sidebar__post-content_meta i {
            font-size: 12px;
            color: var(--thm-primary);
            padding-right: 4px;
        }

        .sidebar__post-content h3 a {
            color: var(--thm-black);
            transition: all 500ms ease;
        }

        .sidebar__post-list li:hover .sidebar__post-content h3 a {
            color: var(--thm-primary);
        }

        .sidebar__category {
            position: relative;
            display: block;
            background: #f3f3f3;
            padding: 45px 30px 36px;
        }

        .sidebar__category .sidebar__title {
            padding-left: 20px;
            margin-bottom: 13px;
        }

        .sidebar__category-list {
            margin: 0;
        }

        .sidebar__category-list li+li {
            margin-top: 8px;
        }

        .sidebar__category-list li a {
            color: var(--thm-gray);
            font-size: 16px;
            font-weight: 500;
            position: relative;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            display: block;
            background: none;
            padding: 2px 20px;
        }

        .sidebar__category-list li a:hover {
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .05);
            color: var(--thm-black);
        }

        .sidebar__category-list li a span {
            position: absolute;
            top: 50%;
            right: 20px;
            transform: translateY(-50%);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            color: var(--thm-black);
            text-align: center;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 15px;
        }

        .sidebar__category-list li a:hover span {
            color: var(--thm-primary);
        }

        .sidebar__tags {
            position: relative;
            display: block;
            background: #f3f3f3;
            padding: 47px 45px 50px;
        }

        .sidebar__tags .sidebar__title {
            margin-left: 5px;
            margin-bottom: 25px;
        }

        .sidebar__tags-list {
            margin-top: -10px;
        }

        .sidebar__tags-list a {
            font-size: 12px;
            color: var(--thm-gray);
            font-weight: 500;
            -webkit-transition: all 0.4s ease;
            transition: all 0.4s ease;
            background: var(--thm-base);
            display: inline-block;
            padding: 3px 14px;
            margin-left: 5px;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        .sidebar__tags-list a+a {
            margin-left: 5px;
            margin-top: 10px;
        }

        .sidebar__tags-list a:hover {
            color: var(--thm-base);
            background: var(--thm-primary);
        }

        .sidebar__comments {
            position: relative;
            display: block;
            background-color: #f3f3f3;
            padding: 45px 48px 43px;
        }

        .sidebar__comments .sidebar__title {
            margin-bottom: 25px;
        }

        .sidebar__comments-list {
            position: relative;
            display: block;
        }

        .sidebar__comments-list li {
            position: relative;
            display: block;
            padding-left: 65px;
        }

        .sidebar__comments-list li+li {
            margin-top: 23px;
        }

        .sidebar__comments-icon {
            height: 45px;
            width: 45px;
            background-color: var(--thm-black);
            border-radius: 50%;
            font-size: 15px;
            color: var(--thm-base);
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: 0;
            left: 0;
            -webkit-transition: all 0.4s ease;
            transition: all 0.4s ease;
        }

        .sidebar__comments-icon:hover {
            background-color: var(--thm-primary);
            color: var(--thm-base);
        }

        .sidebar__comments-icon i {}

        .sidebar__comments-text-box {}

        .sidebar__comments-text-box p {
            font-size: 16px;
            margin: 0;
            line-height: 26px;
            font-weight: 500;
        }

        .sidebar__comments-text-box h5 {
            font-size: 16px;
            color: var(--thm-black);
            line-height: 26px;
            font-weight: 500;
        }

        /*--------------------------------------------------------------
# News Details
--------------------------------------------------------------*/
        .news-details {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .news-details__left {
            position: relative;
            display: block;
        }

        .news-details__img {
            position: relative;
            display: block;
            margin-bottom: 20px;
        }

        .news-details__img img {
            width: 100%;
        }

        .news-details__content {
            position: relative;
            display: block;
        }

        .news-details__meta {
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            margin: 0;
        }

        .news-details__meta li+li {
            margin-left: 15px;
        }

        .news-details__meta li a {
            font-size: 14px;
            color: var(--thm-gray);
            font-weight: 400;
            transition: all 500ms ease;
        }

        .news-details__meta li a:hover {
            color: var(--thm-primary);
        }

        .news-details__meta li a i {
            color: var(--thm-primary);
        }

        .news-details__title {
            font-size: 30px;
            font-weight: 700;
            line-height: 40px;
            margin-bottom: 20px;
        }

        .news-details__text-1 {
            margin: 0;
            padding-bottom: 37px;
        }

        .news-details__text-2 {
            margin: 0;
            padding-bottom: 37px;
        }

        .news-details__text-3 {
            margin: 0;
        }

        .news-details__bottom {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: justify;
            justify-content: space-between;
            flex-wrap: wrap;
            padding: 30px 0 30px;
            margin-top: 51px;
            border-top: 1px solid #e1e1e1;
        }

        .news-details__bottom p {
            margin: 0;
        }

        .news-details__tags {}

        .news-details__tags span {
            color: var(--thm-black);
            font-weight: 700;
            font-size: 16px;
            margin-right: 16px;
        }

        .news-details__tags a {
            position: relative;
            color: var(--thm-gray);
            font-size: 12px;
            font-weight: 500;
            background-color: #f3f3f3;
            display: inline-block;
            padding: 3px 15px;
            text-transform: uppercase;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .news-details__tags a:hover {
            background-color: var(--thm-primary);
            color: var(--thm-base);
        }

        .news-details__tags a+a {
            margin-left: 6px;
        }

        .news-details__social-list {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
        }

        .news-details__social-list a {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: var(--thm-black);
            font-size: 18px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .news-details__social-list a+a {
            margin-left: 30px;
        }

        .news-details__social-list a:hover {
            color: var(--thm-primary);
        }

        .news-details__pagenation-box {
            position: relative;
            display: block;
            overflow: hidden;
            margin-bottom: 55px;
        }

        .news-details__pagenation {
            position: relative;
            display: block;
        }

        .news-details__pagenation li {
            position: relative;
            display: inline-block;
            float: left;
            font-size: 22px;
            color: var(--thm-black);
            background-color: #f3f3f3;
            font-weight: 700;
            line-height: 36px;
            padding: 51px 0px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            max-width: 370px;
            width: 100%;
            padding-left: 60px;
        }

        .news-details__pagenation li+li {
            margin-left: 30px;
        }

        .news-details__pagenation li:hover {
            background-color: var(--thm-primary);
            color: var(--thm-base);
        }

        /*--------------------------------------------------------------
## Comments
--------------------------------------------------------------*/

        .comment-one__title,
        .comment-form__title {
            margin: 0;
            color: var(--thm-black);
            font-size: 26px;
            font-weight: 700;
            margin-bottom: 53px;
        }

        .comment-one__single {
            display: -webkit-box;
            display: flex;
            border-bottom: 1px solid #e1e1e1;
            padding-bottom: 60px;
            margin-bottom: 58px;
        }

        .comment-one__content {
            position: relative;
            margin-left: 45px;
        }

        .comment-one__content h3 {
            margin: 0;
            font-size: 20px;
            color: var(--thm-black);
            font-weight: 700;
            margin-bottom: 25px;
        }

        .comment-one__content p {
            margin: 0;
        }

        .comment-one__btn {
            position: absolute;
            top: 0;
            right: 0;
            background-color: var(--thm-black);
        }

        .comment-one__btn:hover {
            color: var(--thm-base);

        }

        .comment-one__btn .btn-curve {
            background: rgba(var(--thm-base-rgb), .10);
        }

        .comment-one__btn:hover .btn-curve {
            background: rgba(var(--thm-primary-rgb), 1);
        }

        .comment-one__btn .btn-title {
            font-size: 12px;
            line-height: 22px;
            padding: 9px 30px 9px;
        }

        .comment-one__image img {
            border-radius: 50%;
        }

        .comment-form .comment-form__title {
            margin-top: -1px;
        }

        .comment-one__form .row {
            --bs-gutter-x: 20px;
        }

        .comment-form__input-box {
            position: relative;
            display: block;
        }

        .comment-form__input-box input[type="text"],
        .comment-form__input-box input[type="email"] {
            height: 75px;
            width: 100%;
            border: none;
            background: #f3f3f3;
            padding-left: 30px;
            padding-right: 30px;
            margin-bottom: 20px;
            border-radius: 0px;
            outline: none;
            font-size: 14px;
            color: var(--thm-gray);
            font-weight: 500;
            display: block;
        }

        .comment-form__input-box textarea {
            font-size: 14px;
            color: var(--thm-gray);
            font-weight: 500;
            height: 185px;
            width: 100%;
            background: #f3f3f3;
            padding: 20px 30px 30px;
            border: none;
            border-radius: 0px;
            outline: none;
            margin-bottom: 10px;
        }

        .comment-form__btn {
            background-color: var(--thm-black);
            border: none;
            outline: none;
        }

        .comment-form__btn:hover {
            color: var(--thm-base);
            background-color: var(--thm-black);

        }

        .comment-form__btn .btn-curve {
            background: rgba(var(--thm-base-rgb), .10);
        }

        .comment-form__btn:hover .btn-curve {
            background: rgba(var(--thm-primary-rgb), 1);
        }

        /*=========Project Page========*/
        .project-page {
            padding-bottom: 90px;
        }

        /*--------------------------------------------------------------
# Portfolio Detail
--------------------------------------------------------------*/
        .project-details {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .project-details__left {
            position: relative;
            display: block;
        }

        .project-details__img-box {
            position: relative;
            display: block;
        }

        .project-details__img {
            position: relative;
            display: block;
        }

        .project-details__img+.project-details__img {
            margin-top: 30px;
        }

        .project-details__img img {
            width: 100%;
        }

        .project-details__right {}

        .project-details__title {
            font-size: 24px;
            font-weight: 700;
            line-height: 34px;
            margin-top: -5px;
        }

        .project-details__text {
            margin: 0;
            padding-top: 35px;
            padding-bottom: 40px;
        }

        .project-details__info-single {
            position: relative;
            display: block;
        }

        .project-details__info-single+.project-details__info-single {
            margin-top: 10px;
        }

        .project-details__info-client {
            font-size: 20px;
            font-weight: 700;
            line-height: 33px;
        }

        .project-details__info-name {
            font-size: 18px;
            margin: 0;
            color: var(--thm-primary);
        }

        .project-details__social-list {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            margin-top: 43px;
        }

        .project-details__social-list a {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: var(--thm-black);
            border-radius: 50%;
            font-size: 20px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .project-details__social-list a+a {
            margin-left: 32px;
        }

        .project-details__social-list a:hover {
            color: var(--thm-primary);
        }

        .project-details__pagination-box {
            position: relative;
            display: block;
            text-align: center;
            border-top: 1px solid var(--thm-clr-extra);
            border-bottom: 1px solid var(--thm-clr-extra);
            padding: 40px 0;
            margin-top: 120px;
        }

        .project-details__pagination {}

        .project-details__pagination li {
            display: inline-block;
        }

        .project-details__pagination li.next {
            float: left;
            position: relative;
        }

        .project-details__pagination li a {
            font-size: 18px;
            color: var(--thm-black);
            font-weight: 700;
            display: flex;
            align-items: center;
            transition: all 500ms ease;
        }

        .project-details__pagination li a:hover {
            color: var(--thm-primary);
        }

        .project-details__pagination li.next i {
            position: relative;
            transform: rotate(180deg);
            display: inline-block;
            margin-right: 10px;
            font-size: 20px;
        }

        .project-details__pagination li.previous {
            position: relative;
            float: right;
        }

        .project-details__pagination li.previous i {
            margin-left: 10px;
            font-size: 20px;
        }

        /*========Similar Work=======*/
        .similar-work {
            position: relative;
            display: block;
            padding-bottom: 90px;
        }

        .similar-work .project-one__single {
            margin-bottom: 30px;
        }

        .similar-work .project-one__content {
            padding-right: 40px;
        }

        /*--------------------------------------------------------------
# Project Full Width
--------------------------------------------------------------*/
        .project-full-width {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .project-full-width__img {
            position: relative;
            display: block;
        }

        .project-full-width__img img {
            width: 100%;
        }

        .project-full-width__content {
            position: relative;
            display: block;
            margin-top: 32px;
        }

        .project-full-width__title {
            font-size: 30px;
            font-weight: 700;
            line-height: 40px;
            margin-bottom: 35px;
        }

        .project-full-width__text-1 {
            margin: 0;
            padding-bottom: 35px;
        }

        .project-full-width__text-2 {
            margin: 0;
        }

        .project-full-width .project-details__pagination-box {
            margin-top: 113px;
        }

        .project-full-width__details {
            position: absolute;
            bottom: -352px;
            right: 20px;
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .07);
            border: 1px solid var(--thm-clr-extra);
            padding: 45px 50px 49px;
        }

        .project-full-width__details:before {
            position: absolute;
            bottom: -1px;
            right: -1px;
            left: -1px;
            content: "";
            background-color: var(--thm-primary);
            height: 4px;
        }

        .project-full-width__details-info {}

        .project-full-width__details-info-single {}

        .project-full-width__details-info-single+.project-full-width__details-info-single {
            margin-top: 11px;
        }

        .project-full-width__details-info-client {
            font-size: 18px;
            font-weight: 700;
            line-height: 28px;
            margin-bottom: 6px;
        }

        .project-full-width__details-info-name {
            margin: 0;
        }

        .project-full-width__details-social-list {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            border-top: 1px solid var(--thm-clr-extra);
            padding-top: 30px;
            margin-top: 20px;
        }

        .project-full-width__details-social-list a {
            display: -webkit-box;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            -webkit-box-pack: center;
            justify-content: center;
            text-align: center;
            color: var(--thm-black);
            border-radius: 50%;
            font-size: 20px;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .project-full-width__details-social-list a+a {
            margin-left: 30px;
        }

        .project-full-width__details-social-list a:hover {
            color: var(--thm-primary);
        }

        /*===========Services Page==========*/
        .services-page {
            padding: 120px 0 90px;
        }

        .services-page:before {
            display: none;
        }

        /*--------------------------------------------------------------
# Services Details
--------------------------------------------------------------*/
        .service-details {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .service-details__sidebar {
            position: relative;
            display: block;
        }

        .service-details__sidebar-service {
            position: relative;
            display: block;
            background: #f3f3f3;
            padding: 28px 30px 29px;
        }

        .service-details__sidebar-service-list {
            margin: 0;
        }

        .service-details__sidebar-service-list li+li {
            margin-top: 12px;
        }

        .service-details__sidebar-service-list li a {
            color: var(--thm-gray);
            font-size: 16px;
            font-weight: 500;
            position: relative;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            display: block;
            background: none;
            padding: 2px 20px;
        }

        .service-details__sidebar-service-list li.current a,
        .service-details__sidebar-service-list li a:hover {
            background-color: rgb(255, 255, 255);
            box-shadow: 0px 10px 60px 0px rgb(0, 0, 0, .05);
            color: var(--thm-black);
        }

        .service-details__sidebar-service-list li a span {
            position: absolute;
            top: 50%;
            right: 20px;
            transform: translateY(-50%);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            color: var(--thm-black);
            text-align: center;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 15px;
        }

        .service-details__sidebar-service-list li.current a span,
        .service-details__sidebar-service-list li a:hover span {
            color: var(--thm-primary);
        }

        .service-details__need-help {
            position: relative;
            display: block;
            padding: 43px 50px 55px;
            margin-top: 30px;
            background-color: var(--thm-black);
        }

        .service-details__need-help-title {
            font-size: 20px;
            color: var(--thm-base);
            font-weight: 700;
            line-height: 30px;
        }

        .service-details__need-help-text {
            color: #aeaeae;
            margin: 0;
            padding-top: 34px;
            padding-bottom: 26px;
            line-height: 30px;
        }

        .service-details__need-help-phone {
            display: flex;
            align-items: center;
        }

        .service-details__need-help-phone-icon {
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            color: var(--thm-primary);
            transition: all 500ms ease;
        }

        .service-details__need-help-phone-icon:hover {
            color: var(--thm-base);
        }

        .service-details__need-help-phone-icon span {}

        .service-details__need-help-phone-number {
            margin-left: 20px;
        }

        .service-details__need-help-phone-number h4 {
            font-size: 26px;
            font-weight: 700;
            line-height: 36px;
        }

        .service-details__need-help-phone-number h4 a {
            color: var(--thm-base);
            transition: all 500ms ease;
        }

        .service-details__need-help-phone-number h4 a:hover {
            color: var(--thm-primary);
        }

        .service-details__right {
            position: relative;
            display: block;
        }

        .service-details__img {
            position: relative;
            display: block;
        }

        .service-details__img img {
            width: 100%;
        }

        .service-details__icon {
            position: absolute;
            bottom: -40px;
            ;
            right: 30px;
            height: 100px;
            width: 100px;
            background-color: var(--thm-primary);
            font-size: 60px;
            color: var(--thm-base);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .service-details__icon span {}

        .service-details__content {
            position: relative;
            display: block;
            margin-top: 32px;
        }

        .service-details__title {
            font-size: 30px;
            font-weight: 700;
            line-height: 40px;
            margin-bottom: 35px;
        }

        .service-details__text {
            margin: 0;
        }

        .service-details__benefits {
            position: relative;
            display: block;
            margin-top: 51px;
            margin-bottom: 60px;
        }

        .service-details__benefits-img {
            position: relative;
            display: block;
        }

        .service-details__benefits-img img {
            width: 100%;
        }

        .service-details__benefits-text {}

        .service-details__benefits-title {
            font-size: 26px;
            font-weight: 700;
            line-height: 36px;
            margin-bottom: 26px;
            margin-top: -8px;
        }

        .service-details__benefits-text {
            font-size: 18px;
            margin: 0;
        }

        .service-details__benefits-list {
            position: relative;
            display: block;
            margin-top: 36px;
        }

        .service-details__benefits-list li {
            position: relative;
            display: flex;
            align-items: center;
        }

        .service-details__benefits-list li+li {
            margin-top: 6px;
        }

        .service-details__benefits-list li .icon {}

        .service-details__benefits-list li .icon span {
            font-size: 16px;
            color: var(--thm-primary);
        }

        .service-details__benefits-list li .text {
            margin-left: 10px;
        }

        .service-details__benefits-list li .text p {
            font-size: 18px;
            color: var(--thm-black);
            font-weight: 500;
            margin: 0;
        }

        .service-details__faq {}

        /*--------------------------------------------------------------
# Location
--------------------------------------------------------------*/
        .location {
            position: relative;
            display: block;
            padding: 120px 0 90px;
        }

        .location__single {
            position: relative;
            display: block;
            margin-bottom: 30px;
        }

        .location__img {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .location__img:before {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            content: "";
            background-color: rgba(var(--thm-black-rgb), .50);
            transform: scaleX(0);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
            z-index: 1;
        }

        .location__single:hover .location__img:before {
            transform: scaleX(1);
        }

        .location__img img {
            width: 100%;
            transform: scale(1);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .location__single:hover .location__img img {
            transform: scale(1.05);
        }

        .location__content {
            position: relative;
            display: block;
            padding: 32px 40px 30px;
            border: 1px solid var(--thm-clr-extra);
            border-top: 0;
        }

        .location__title {
            font-size: 24px;
            font-weight: 700;
            line-height: 34px;
            margin-bottom: 21px;
        }

        .loaction__list {
            position: relative;
            display: block;
        }

        .loaction__list li {
            position: relative;
            display: flex;
            align-items: center;
        }

        .loaction__list li .icon {
            display: flex;
            align-items: center;
        }

        .loaction__list li .icon span {
            font-size: 14px;
            color: var(--thm-primary);
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .loaction__list li .icon:hover span {
            color: var(--thm-black);
        }

        .loaction__list li .text {
            margin-left: 14px;
        }

        .loaction__list li .text p {
            font-size: 18px;
            margin: 0;
        }

        .loaction__list li .text p a {
            color: var(--thm-gray);
            font-size: 18px;
            margin: 0;
            -webkit-transition: all 500ms ease;
            transition: all 500ms ease;
        }

        .loaction__list li .text p a:hover {
            color: var(--thm-primary);
        }

        /*--------------------------------------------------------------
## Contact Page
--------------------------------------------------------------*/
        .contact-page {
            position: relative;
            display: block;
            padding: 0px 0 120px;
        }

        .contact-page .container {
            max-width: 768px;
            width: 100%;
        }

        .contact-page__form {}

        .contact-page__btn-box {
            position: relative;
            display: block;
            text-align: center;
        }

        .contact-page__btn {}

        /*--------------------------------------------------------------
# Contact Page Google Map
--------------------------------------------------------------*/
        .contact-page-google-map {
            position: relative;
            display: block;
        }

        .contact-page-google-map__one {
            position: relative;
            display: block;
            border: none;
            height: 560px;
            width: 100%;
        }

        /*--------------------------------------------------------------
## Error Page
--------------------------------------------------------------*/
        .error-page {
            position: relative;
            display: block;
            padding: 72px 0 120px;
        }

        .error-page__inner {
            position: relative;
            display: block;
            text-align: center;
        }

        .error-page__title {
            font-size: 350px;
            font-weight: 400;
            line-height: 350px;
            color: var(--thm-primary);
        }

        .error-page__tagline {
            font-size: 36px;
            font-weight: 400;
            line-height: 46px;
            margin-bottom: 7px;
            margin-top: 3px;
        }

        .error-page__text {
            font-size: 20px;
            font-weight: 400;
            margin: 0;
        }

        .error-page__form {
            position: relative;
            display: block;
            max-width: 685px;
            width: 100%;
            margin: 54px auto 20px;
        }

        .error-page__form-input {
            position: relative;
            display: block;
            max-width: 530px;
            width: 100%;
            margin: 0 auto;
        }

        .error-page__form input[type="search"] {
            height: 75px;
            width: 100%;
            border: none;
            outline: none;
            background-color: #f3f3f3;
            font-size: 16px;
            color: var(--thm-gray);
            font-weight: 400;
            padding-left: 50px;
            padding-right: 75px;
            border-radius: 0;
        }

        .error-page__form button[type="submit"] {
            background-color: transparent;
            color: var(--thm-black);
            font-size: 22px;
            position: absolute;
            top: 0;
            right: 28px;
            bottom: 0;
            width: 50px;
            outline: none;
            border: none;
            display: flex;
            align-items: center;
        }

        .error-page__btn {}

        .error-page__btn:hover {
            background-color: var(--thm-black);
            color: var(--thm-base);
        }

        /*--------------------------------------------------------------
## FAQs Page
--------------------------------------------------------------*/
        .faqs-page {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .faqs-page__single {
            position: relative;
            display: block;
        }

        /*=====Team Page======*/
        .team-page {
            padding: 120px 0 90px;
        }

        /*--------------------------------------------------------------
## About Page
--------------------------------------------------------------*/
        .about-page {
            position: relative;
            display: block;
            padding: 120px 0 120px;
        }

        .about-page__images-box {
            position: relative;
            display: block;
        }

        .about-page__img-list {
            position: relative;
            display: block;
            overflow: hidden;
        }

        .about-page__img-list li {
            position: relative;
            display: inline-block;
            float: left;
        }

        .about-page__img-list li+li {
            margin-left: 30px;
        }

        .about-page__img {
            position: relative;
            display: inline-block;
        }

        .about-page__img img {}

        .about-page__right {
            position: relative;
            display: block;
            margin-left: 68px;
        }

        .about-page__right .section-title {
            margin-bottom: 37px;
        }

        .about-page__right-text {
            font-size: 18px;
            color: #6c757d;
            font-weight: 700;
            line-height: 36px;
            padding-bottom: 24px;
        }

        .about-page__points {
            position: relative;
            display: block;
        }

        .about-page__points li {
            position: relative;
            display: block;
            padding-left: 86px;
            border-bottom: 1px solid #e2e2e2;
            padding-bottom: 40px;
            margin-bottom: 42px;
        }

        .about-page__points li:last-child {
            margin-bottom: 0;
            padding-bottom: 0px;
            border-bottom: 0;
        }

        .about-page__points li .icon {
            height: 57px;
            width: 57px;
            background-color: rgba(var(--thm-primary-rgb), .10);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            color: var(--thm-primary);
            position: absolute;
            top: 8px;
            left: 0;
            transition: all 500ms ease;
        }

        .about-page__points li:hover .icon {
            background-color: rgba(var(--thm-primary-rgb), 1);
            color: var(--thm-base);
        }

        .about-page__points li .icon span {}

        .about-page__points li .text {}

        .about-page__points li .text h3 {
            font-size: 20px;
            font-weight: 700;
            line-height: 30px;
        }

        .about-page__points li .text p {
            margin: 0;
            line-height: 30px;
            padding-top: 12px;
        }

        /*About Page Have Questions*/
        .about-page-have-questions {
            padding-top: 120px;
        }

        /*About Page Team*/
        .about-page-team {}

        /*About Page Brand*/
        .about-page-brand {
            background-color: #f3f3f3;
            border-top: 0;
        }

        /* cs */
        .center-xy {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .btn-close:focus {
            box-shadow: 0 0 0 0.25rem #b0081887;
        }

        .hover-primary:hover {
            color: #b00818;
        }

        .widget__links-list {
            position: relative;
            display: block;
        }

        .widget__links-list li+li {
            margin-top: 5px;
        }

        .widget__links-list li a {
            position: relative;
            display: inline-block;
            transition: all 500ms ease;
        }

        .widget__links-list li a:hover {
            padding-left: 20px;
            color: var(--thm-primary);
        }

        .widget__links-list li a.active {
            padding-left: 20px;
            color: var(--thm-primary);
        }

        .widget__links-list li a:before {
            position: absolute;
            top: 50%;
            left: 0;
            bottom: 0;
            width: 10px;
            height: 2px;
            content: "";
            background-color: var(--thm-primary);
            transform: translateY(-50%);
            opacity: 0;
            transition: all 500ms ease;
        }

        .widget__links-list li a.active:before {
            position: absolute;
            top: 50%;
            left: 0;
            bottom: 0;
            width: 10px;
            height: 2px;
            content: "";
            background-color: var(--thm-primary);
            transform: translateY(-50%);
            opacity: 0;
            transition: all 500ms ease;
            opacity: 1;
        }

        .widget__links-list li a:hover:before {
            opacity: 1;
        }

        .project-one__logo {
            position: absolute;
            top: -55px;
            right: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .project-one__logo>a {
            position: relative;
            height: 55px;
            /* width: 55px; */
            background-color: #b0081836;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: var(--thm-base);
            transition: all 500ms ease;
            border: var(--thm-primary) 1px solid;
        }

        .project-one__logo>a:hover {
            background-color: #b008180f;
        }

        .widget__contact-list {
            position: relative;
            display: block;
        }

        .widget__contact-list li {
            display: flex;
        }

        .widget__contact-list li+li {
            margin-top: 12px;
        }

        .widget__contact-list li .icon {}

        .widget__contact-list li .icon span {
            font-size: 15px;
            color: var(--thm-primary);
        }

        .widget__contact-list li .text {
            margin-left: 10px;
        }

        .widget__contact-list li .text p {
            font-size: 14px;
            color: #aeaeae;
            font-weight: 500;
            margin: 0;
            line-height: 30px;
        }

        .widget__contact-list li .text p a {
            font-size: 14px;
            color: #aeaeae;
            font-weight: 500;
            transition: all 500ms ease;
        }

        .widget__contact-list li .text a:hover {
            color: var(--thm-primary);
        }

        .primary-content>div:first-childd {
            max-height: 500px;
            overflow-y: scroll;
            overflow-x: hidden;
        }
    </style>
</head>


<body style="max-width: 1600px;" class="mx-auto">
    <div class="preloader">
        <img class="preloader__image" width="60" src="<?php echo e(asset('/images/loader.png')); ?>" alt="" />
    </div>

    <?php if(Session::has('message') or $errors->any()): ?>
        <div class="modal fade" id="modal-message" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header text-right ml-auto pr-0">
                        <button type="button" class="btn btn_brown rounded-circle" data-bs-dismiss="modal">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <?php if($errors->any()): ?>
                            <?php echo $__env->make('include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php else: ?>
                            <?php echo e(Session::get('message')); ?>

                            <?php echo e(Session::forget('message')); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="page-wrapper">
        <?php echo $__env->make('layouts.front.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->yieldContent('content'); ?>


    </div>

    <div class="mobile-nav__wrapper" style="z-index: 100;">
        <div class="mobile-nav__overlay mobile-nav__toggler"></div>
        <!-- /.mobile-nav__overlay -->
        <div class="mobile-nav__content">
            <span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

            <div class="logo-box">
                <a href="index.html" aria-label="logo image"><img src="<?php echo e(asset('/images/resources/logo-2.png')); ?>"
                        width="155" alt="" /></a>
            </div>
            <!-- /.logo-box -->
            <div class="mobile-nav__container"></div>
            <!-- /.mobile-nav__container -->

            <ul class="mobile-nav__contact list-unstyled">
                <li>
                    <i class="fa fa-envelope"></i>
                    <a href="mailto:inquireqprohq@quantaservices.com">inquireqprohq@quantaservices.com</a>
                </li>
                <li>
                    <i class="fa fa-phone-alt"></i>
                    <a href="tel:+63286619398">+632 8661 9398 <br>
                        +632 8661 9433</a>
                </li>
            </ul><!-- /.mobile-nav__contact -->

        </div>
        <!-- /.mobile-nav__content -->
    </div>
    <!-- /.mobile-nav__wrapper -->

    <div class="search-popup">
        <div class="search-popup__overlay search-toggler"></div>
        <!-- /.search-popup__overlay -->
        <div class="search-popup__content">
            <form action="#">
                <label for="search" class="sr-only">search here</label><!-- /.sr-only -->
                <input type="text" id="search" placeholder="Search Here..." />
                <button type="submit" aria-label="search submit" class="thm-btn">
                    <i class="icon-magnifying-glass"></i>
                </button>
            </form>
        </div>
        <!-- /.search-popup__content -->
    </div>
    <!-- /.search-popup -->

    <a href="#" data-target="html" class="scroll-to-target scroll-to-top"><i class="fa fa-angle-up"></i></a>

    <script src="<?php echo e(asset('/vendors/jquery/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jarallax/jarallax.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jquery-appear/jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jquery-circle-progress/jquery.circle-progress.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jquery-validate/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/nouislider/nouislider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/odometer/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/swiper/swiper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/tiny-slider/tiny-slider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/wnumb/wNumb.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/wow/wow.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/isotope/isotope.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/countdown/countdown.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/twentytwenty/twentytwenty.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/twentytwenty/jquery.event.move.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/bxslider/jquery.bxslider.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/vegas/vegas.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/jquery-ui/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendors/timepicker/timePicker.js')); ?>"></script>


    <script src="http://maps.google.com/maps/api/js?key=AIzaSyATY4Rxc8jNvDpsK8ZetC7JyN4PFVYGCGM"></script>


    <!-- template js -->
    <script src="<?php echo e(asset('/js/kontin.js')); ?>"></script>

    <?php if(Session::has('success')): ?>
        <div id="success" class="d-none"><?php echo e(Session::get('success')); ?></div>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            })

            Toast.fire({
                icon: 'success',
                title: document.getElementById('success').innerHTML
            })
        </script>
    <?php endif; ?>
    <?php if(Session::has('warning')): ?>
        <div id="warning" class="d-none"><?php echo e(Session::get('warning')); ?></div>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            })

            Toast.fire({
                icon: 'error',
                title: document.getElementById('warning').innerHTML
            })
        </script>
    <?php endif; ?>
    <script>
        $(window).on('load', function() {
            $('#modal-message').modal('show');
        });
    </script>

    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH D:\sastre_projects\QUANTA\resources\views/layouts/front/app.blade.php ENDPATH**/ ?>