
<?php $__env->startSection('meta'); ?>
	<title>Blog Title | <?php echo e(env('APP_NAME')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<section id="page_header" style="background: url(<?php echo e(asset('images/header/singleblog.jpg')); ?>)">
		<div class="container-fluid page_overlay">
			<div class="container">
				<div class="row">
					<div class="col-lg-5 my-auto">
						<p>Blogs</p>
						<h1>
							<?php echo e($blog->title); ?> 
							<u></u>
							<span class="passion">
								Blogs
							</span>
						</h1>
						<br>
						<!-- <p>
							Dynamically target high-payoff intellectual capital for customized technologies for box quality. Objectively integrate emerging core competency innovations.
						</p> -->
					</div>
				</div>
			</div>
		</div>
	</section>
	<section class="blogSection">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<img src="<?php echo e(asset('images/group.jpg')); ?>" class="img-fluid">
					
				</div>
				<div class="col-lg-9 col-md-8">
					<div class="card blogCard">
						<div class="card-body pl-0">
							<h4 class="font-weight-bold">
								<?php echo e($blog->title); ?>

							</h4>
							<div class="py-3">
								<?php echo $blog->description; ?>

							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-md-4">
					<div class="card blogCard">
						<div class="card-body">
							<div class="row">
								<div class="col-4">
									<label>Year:</label>
								</div>
								<div class="col-8">
									<p><?php echo e(date('Y', strtotime($blog->blog_date))); ?></p>
								</div>
								<div class="col-4">
									<label>Tag:</label>
								</div>
								<div class="col-8">
									<p>
										<?php if(json_decode($blog->tag_id)): ?>
											<?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<?php if(in_array($tag->id, json_decode($blog->tag_id))): ?>
													<?php echo e($tag->name); ?> 
												<?php endif; ?>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php endif; ?>
									</p>
								</div>
								<div class="col-4">
									<label>Client:</label>
								</div>
								<div class="col-8">
									<p><?php echo e($blog->client); ?></p>
								</div>
								<div class="col-lg-12">
									<a href="" class="btn btn_social">
										<i class="fab fa-facebook-f"></i>
									</a>
									<a href="" class="btn btn_social">
										<i class="fab fa-pinterest"></i>
									</a>
									<a href="" class="btn btn_social">
										<i class="fab fa-twitter"></i>
									</a>
									<a href="" class="btn btn_social">
										<i class="fab fa-linkedin-in"></i>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-lg-12 mb-3">
					<div class="card commentCard">
						<div class="card-header">
							<h2>Leave a Comment</h2>
						</div>
						<div class="card-body">
							<form method="post" class="replyForm" action="<?php echo e(route('send.comment')); ?>">
								<?php echo csrf_field(); ?>
								<div class="row">
									<input type="text" name="blog_id" value="<?php echo e($blog->id); ?>" hidden="">
									<div class="col-sm-6 form-group">
										<input type="text" name="name" class="form-control" value="<?php echo e(old('name')); ?>" placeholder="Name" required="">
									</div>
									<div class="col-sm-6 form-group">
										<input type="email" name="email" class="form-control" value="<?php echo e(old('email')); ?>" placeholder="Email" required="">
									</div>
									<div class="col-sm-12 form-group">
										<textarea name="message" placeholder="Comment" class="form-control" rows="5" required=""><?php echo e(old('message')); ?></textarea>
									</div>
									<div class="col-sm-12">
										<p>
											Your email address will not be published. Required fields are marked *
										</p>
										<div class="btn-group mr-2" role="group" aria-label="Second group">
										    <button type="submit" class="btn btn_brown">Post Comment</button>
											<button class="btn btn_dbrown" type="submit">
												<i class="fas fa-paper-plane"></i>
											</button>
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>

				<div class="col-sm-6">
					<?php if($prev): ?>
					<div class="card prevCard pl-2">
						<div class="row">
				      		<img src="<?php echo e(asset('uploads/blogs/'.$prev->image)); ?>" class="img-fluid" alt="" style="">
				      		<div class="card-body pr-0 py-0 my-auto">
			        			<p class="mb-0">Previous</p>
				        		<a href="<?php echo e(url('blog/'.str_replace([' ', '/'], ['_', '`'], $prev->title))); ?>" class=" font-weight-bold"><?php echo e($prev->title); ?></a>
				      		</div>
				      	</div>
					</div>
					<?php endif; ?>
				</div>
				<div class="col-sm-6">
					<?php if($next): ?>
					<div class="card prevCard pr-2">
						<div class="row">
				      		<div class="card-body pl-0 py-0 my-auto text-right">
			        			<p class="mb-0">Next</p>
				        		<a href="<?php echo e(url('blog/'.str_replace([' ', '/'], ['_', '`'], $next->title))); ?>" class=" font-weight-bold"><?php echo e($next->title); ?></a>
				      		</div>
				      		<img src="<?php echo e(asset('uploads/blogs/'.$next->image)); ?>" class="img-fluid" alt="" style="">
				      	</div>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.front.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\dev\dfiberboard\resources\views/front/blog-single.blade.php ENDPATH**/ ?>