<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Client;
use Validator;
use Str;

class ClientController extends Controller
{

    public function index()
    {
        $data = Client::latest()->get();
        // return $data;
        return view('module.client.index', compact('data'));
    }

    public function create()
    {
        return view('module.client.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'description' => ['required'],
            // 'link' => ['required'],
            'logo' => ['required','image','max:2048'],
        ]);

        if ($request->logo) {
            $file = $request->logo;
            // return $request->logo;
            $path = public_path() . '/uploads/clients';
            $img = str_replace(' ', '_', $request->name) . date_format(date_create(), 'mdyHis') . Str::random(5) . '.' . $file->getClientOriginalExtension();
            $request->logo->move($path, $img);
            $request->logo = $img;
        }

        // if($validator->fails()){
        //     return back()->withInput()->withErrors($validator);
        // }

        Client::create([
            'name' => $request->name,
            'description' => $request->description,
            'logo' => $request->logo,
            // 'link' => $request->link,
        ]);

        return back()->with('success', 'Successfully added new client');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $data = Client::findOrFail($id);
        return view('module.client.edit', compact('data'));
    }


    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
            'description2' => ['required'],
            'logo' => ['nullable','image','max:2048'],
        ]);

        if ($validator->fails()) {
            return back()->withInput()->withErrors($validator);
        }

        $client = Client::findOrFail($id);
        $client->name = $request->name;
        $client->description = $request->description2;
        // $client->link = $request->link;

        if ($request->logo) {

            $path = public_path('uploads/clients/');

            // Check if old logo exists before deleting
            if ($client->logo && file_exists($path . $client->logo)) {
                unlink($path . $client->logo);
            }

            $file = $request->file('logo');

            // Generate new filename
            $img = str_replace(' ', '_', $request->name)
                . date('mdyHis')
                . Str::random(5)
                . '.' . $file->getClientOriginalExtension();

            // Move the uploaded file
            $file->move($path, $img);

            $client->logo = $img;
        }

        $client->active = $request->active;
        $client->save();



        return back()->with('success', 'Successfully updated client');
    }


    public function destroy($id)
    {
        $client = Client::findOrFail($id)->active = 0;
        return back()->with('success', 'Successfully Hidden client');
    }
}
