<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Testimonial;
use Validator;
use Str;

class TestimonialController extends Controller
{
    
    public function index()
    {
        $data = Testimonial::latest()->get();
        return view('module.testimonial.index', compact('data'));
    }

    
    public function create()
    {
        //
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'position' => 'required',
            'message' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:1048',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->image){
            $path = public_path().'/uploads/testimonial';
            $img = str_replace(' ', '_', $request->name).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $request->image = $img;
        }

        Testimonial::create([
            'name' => $request->name,
            'position' => $request->position,
            'message' => $request->message,
            'image' => $request->image,
        ]);

        return back()->with('success', 'Successfully added new testimonial');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'position' => 'required',
            'message' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $testimonial = Testimonial::findOrFail($id);
        $testimonial->name = $request->name;
        $testimonial->position = $request->position;
        $testimonial->message = $request->message;

        if($request->image){
            $path = public_path().'/uploads/testimonial';
            $img = str_replace(' ', '_', $request->name).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $testimonial->image = $img;
        }

        $data = Testimonial::findOrFail($id);
        $testimonial->save();

        if($request->image and $data->image){
            $path = public_path().'/uploads/testimonial/';
            unlink($path.$data->image);
        }

        return back()->with('success', 'Successfully updated testimonial');
    }

    
    public function destroy($id)
    {
        $data = Testimonial::findOrFail($id);
        $data->delete();
        if($data->image){
            $path = public_path().'/uploads/testimonial/';
            unlink($path.$data->image);
        }
        return back()->with('success', 'Successfully deleted testimonial');
    }
}
