<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('order_no');
            $table->string('bill_name');
            $table->string('bill_email');
            $table->string('bill_mobile');
            $table->string('bill_address');
            $table->string('payment_method');
            $table->string('payment_reference')->nullable();
            $table->string('payment_status')->string('Unpaid');
            $table->longText('order_items');
            $table->double('total_amount_due');
            $table->string('status')->default('Order Placed');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
