@extends('layouts.front.app')
@section('meta')
    <title>Home | {{ env('APP_NAME') }}</title>
    <meta name="description" content="Providing high-quality workforce and hosted services to Quanta Operating units" />

@stop
@section('css')
    <style>
        .dropdown-item:hover {
            background-color: #b00818;
        }

        .btn-close:focus {
            box-shadow: 0 0 0 0.25rem #b0081887;
        }
    </style>
@endsection
@section('content')
    <!-- Banner One Start -->
    <section class="main-slider">
        <div class="swiper-container thm-swiper__slider"
            data-swiper-options='{"slidesPerView": 1, "loop": true,
        "effect": "fade",
            "pagination": {
            "el": "#main-slider-pagination",
            "type": "bullets",
            "clickable": true
        },
            "navigation": {
            "nextEl": "#main-slider__swiper-button-next",
            "prevEl": "#main-slider__swiper-button-prev"
            },
            "autoplay": {
            "delay": 20000
        }}'>
            {{-- <div class="swiper-container thm-swiper__slider"> --}}
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="image-layer"
                        style="background-image: url({{ asset('/images/backgrounds/home-banner894x425.jpg)') }};"></div>

                    <div class="image-layer-overlay"></div>

                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="main-slider__content">
                                    <p class="mb-0 text-website-secondary">#WEAREQUANTA</p>

                                    <h2>WORLD-CLASS QUALITY <br> <span class="highligh">LOCAL TALENT <br> GLOBAL IMPACT</span></h2>
                                    <!--<h2 class="text-website-secondary">QUANTA COMPANY</h2>-->
                                    <p class="text-white fs-4 w-50" style="text-align: justify;">Based in Manila, Quanta Philippines ROHQ connects local expertise to global energy and infrastructure projects. We’re proud to deliver exceptional workforce solutions — and to offer meaningful careers with a company that powers progress around the world.</p>

                                    <div class="main-slider__side-text">Quanta Company</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="image-layer"
                        style="background-image: url({{ asset('/images/backgrounds/main-slider-1-') }}2.jpg);">
                    </div>

                    <div class="image-layer-overlay"></div>

                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="main-slider__content">
                                    <p class="mb-0 text-website-secondary">#WEAREQUANTA</p>

                                    <h2>WORLD-CLASS QUALITY <br> <span class="highligh">LOCAL TALENT <br> GLOBAL IMPACT</span></h2>
                                    <!--<h2 class="text-website-secondary">QUANTA COMPANY</h2>-->
                                    <p class="text-white fs-4 w-50" style="text-align: justify;">Based in Manila, Quanta Philippines ROHQ connects local expertise to global energy and infrastructure projects. We’re proud to deliver exceptional workforce solutions — and to offer meaningful careers with a company that powers progress around the world.</p>

                                    <div class="main-slider__side-text">Quanta Company</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="swiper-slide">
                    <div class="image-layer"
                        style="background-image: url({{ asset('/images/backgrounds/main-slider-1-') }}3.jpg);">
                    </div>

                    <div class="image-layer-overlay"></div>

                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="main-slider__content">
                                    <p class="mb-0 text-website-secondary">#WEAREQUANTA</p>

                                    <h2>WORLD-CLASS QUALITY <br> <span class="highligh">LOCAL TALENT <br> GLOBAL IMPACT</span></h2>
                                    <!--<h2 class="text-website-secondary">QUANTA COMPANY</h2>-->
                                    <p class="text-white fs-4 w-50" style="text-align: justify;">Based in Manila, Quanta Philippines ROHQ connects local expertise to global energy and infrastructure projects. We’re proud to deliver exceptional workforce solutions — and to offer meaningful careers with a company that powers progress around the world.</p>

                                    <div class="main-slider__side-text">Quanta Company</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <!-- If we need navigation buttons -->
            <div class="swiper-pagination" id="main-slider-pagination"></div>
            <div class="main-slider__nav">
                <div class="swiper-button-prev" id="main-slider__swiper-button-next">
                    <i class="icon-right-arrow icon-left-arrow"></i>
                </div>
                <div class="swiper-button-next" id="main-slider__swiper-button-prev">
                    <i class="icon-right-arrow"></i>
                </div>
            </div>
        </div>
    </section>
    <!--Banner One End-->
    <section class="welcome-one">
        <div class="image-layer py-3 py-sm-5"
            style="
            background-repeat: no-repeat;
            background-size: cover;
            background-image: url({{ asset('/images/backgrounds/save-1894x425.jpg)') }};
            ">
            <div class="container py-5 wow slideInRight" data-wow-delay="100ms">
                <h2 class="text-website-primary text-uppercase text-center mb-3">EXPAND YOUR REACH, MAINTAIN YOUR CONTROL</h2>
                <h4 class="text-center mb-3">We help you build an extension of your business in the Philippines — staffed by local experts in Engineering, IT, HR, recruitment, and back-office operations — so you can scale efficiently while retaining full control over quality and outcomes.
                </h4>
                <div class="text-center">
                    <a href="{{ url('/our-company/about-quanta') }}" class="btn-style-one">
                        <i class="btn-curve"></i>
                        <span class="btn-title">Learn More</span>
                    </a>
                </div>
            </div>
        </div>
    </section>
    <section class="welcome-on">
        <div class="image-layer" style="">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="project-one__single">
                            <div class="project-one__img">
                                <img style="height: 635px" src="{{ asset('/images/backgrounds/service1-630x425.jpg') }}"
                                    alt="">
                                <div class="project-one__content" style="background: #00000085;">
                                    <div class="project-one__arro mb-2">
                                        <a href="{{ url('projects') }}" class="p-3 active-subnav">PROJECTS</a>
                                    </div>
                                    {{-- <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5> --}}
                                    <p class=""><a href="{{ url('projects') }}" class="text-white">Building global projects since 2012 — powered by skilled teams in the Philippines and trusted by Quanta companies worldwide.
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="project-one__single">
                            <div class="project-one__img">
                                <img style="height: 635px" src="{{ asset('/images/backgrounds/service2-630x425.jpg') }}"
                                    alt="">
                                <div class="project-one__content" style="background: #00000085;">
                                    <div class="project-one__arro mb-2">
                                        <a href="{{ url('clients') }}" class="p-3 active-subnav">CLIENTS</a>
                                    </div>
                                    {{-- <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5> --}}
                                    <p class=""><a href="{{ url('clients') }}" class="text-white">We partner with Quanta operating units worldwide to deliver seamless, high-value business solutions — helping every project achieve more.
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="project-one__single">
                            <div class="project-one__img">
                                <img style="height: 635px" src="{{ asset('/images/backgrounds/service3-630x425.jpg') }}"
                                    alt="">
                                <div class="project-one__content" style="background: #00000085;">
                                    <div class="project-one__arro mb-2">
                                        <a href="{{ url('careers') }}" class="p-3 active-subnav">CAREERS</a>
                                    </div>
                                    {{-- <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5> --}}
                                    <p class=""><a href="{{ url('careers') }}" class="text-white">Grow your career with a company that connects local talent to global impact.
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>

    <!--Services One End-->
    <!--Welcome One Start-->
    <section class="welcome-one">
        <div class="container">
            <div class="row">
                <div class="col-xl-6">
                    <div class="welcome-one__left mx-5 wow slideInLeft" data-wow-delay="100ms"
                        data-wow-duration="2500ms">
                        <div class="welcome-one__img-box">
                            <div class="welcome-one__img">
                                <img src="{{ asset('/images/resources/welcome-one-img-1.jpg') }}" alt="">
                            </div>
                            <div class="welcome-one__small-img">
                                <img src="{{ asset('/images/resources/welcome-one-small-img.jpg') }}" alt="">
                            </div>
                            <div class="welcome-one__completed">
                                <div class="welcome-one__completed-icon">
                                    <span class="icon-creative-design"></span>
                                </div>
                                {{-- <div class="welcome-one__completed-text">
                                <h6><span class="odometer" data-count="1000">0</span> Industry <br> Projects
                                    Completed</h6>
                            </div> --}}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="welcome-one__right">
                        <div class="section-title text-left">
                            <span class="section-title__tagline">Welcome to Quanta Philippines ROHQ</span>
                            <h2 class="section-title__title">WELCOME TO QUANTA PHILIPPINES ROHQ
Let’s Build Something Creative Together</h2>
                        </div>
                        <p class="welcome-one__right-text-1">Where Quality Meets Affordability.
                        </p>
                        <p class="welcome-one__right-text-2">Based in Manila, Quanta Philippines ROHQ is part of the global Quanta Services network — delivering first-class, cost-effective engineering, design and hosted, services across the electric power, pipeline, industrial, and telecommunications sectors.</p>
                        <ul class="list-unstyled welcome-one__list">
                            <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>Engineering Design Services</p>
                                </div>
                            </li>
                            <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>Telecommunication Engineering</p>
                                </div>
                            </li>
                            <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>Mechanical / Piping Engineering</p>
                                </div>
                            </li>
                            <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>Electrical / E&I Engineering</p>
                                </div>
                            </li>
                             <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>IT Services</p>
                                </div>
                            </li>
                            <!--<li>-->
                            <!--    <div class="welcome-one__list-icon">-->
                            <!--        <span class="icon-check"></span>-->
                            <!--    </div>-->
                            <!--    <div class="welcome-one__list-text">-->
                            <!--        <p>Solar Design</p>-->
                            <!--    </div>-->
                            <!--</li>-->
                            <!--<li>-->
                            <!--    <div class="welcome-one__list-icon">-->
                            <!--        <span class="icon-check"></span>-->
                            <!--    </div>-->
                            <!--    <div class="welcome-one__list-text">-->
                            <!--        <p>Project management and construction supervision, testing and commissioning</p>-->
                            <!--    </div>-->
                            <!--</li>-->
                            <!--<li>-->
                            <!--    <div class="welcome-one__list-icon">-->
                            <!--        <span class="icon-check"></span>-->
                            <!--    </div>-->
                            <!--    <div class="welcome-one__list-text">-->
                            <!--        <p>Safety Consultancy</p>-->
                            <!--    </div>-->
                            <!--</li>-->
                            <!--<li>-->
                            <!--    <div class="welcome-one__list-icon">-->
                            <!--        <span class="icon-check"></span>-->
                            <!--    </div>-->
                            <!--    <div class="welcome-one__list-text">-->
                            <!--        <p>Labor solutions for energized services - Certified Journey Linemen</p>-->
                            <!--    </div>-->
                            <!--</li>-->
                             <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>Back-office support (finance and administration)</p>
                                </div>
                            </li>
                             <li>
                                <div class="welcome-one__list-icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="welcome-one__list-text">
                                    <p>Immigration and Global Mobility support </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Welcome One End-->

    <!--Services One Start-->
    <section class="services-one">
        <div class="container">
            <div class="section-title text-center">
                <span class="section-title__tagline">Services we’re offering</span>
                <h2 class="section-title__title">Industries We Serve</h2>
                <h4 class="text-center mb-3">From power and pipelines to telecom and renewables, Quanta Philippines ROHQ supports infrastructure that keeps the world connected.</h4>
            </div>
            <div class="row">
                <div class="col-xl-4 col-lg-4 wow fadeInLeft" data-wow-duration="1500ms" data-wow-delay="0ms">
                    <!--Services One Single-->
                    <div class="services-one__single">
                        <div class="services-one__img">
                            <img src="{{ asset('/images/telecom 2.webp') }}" alt="">
                            <div class="services-one__icon">
                                <span class="icon-industrial"></span>
                            </div>
                        </div>
                        <div class="services-one__content">
                            <h3 class="services-one__title"><a href="industry-Electrical.html">Telecommunication
                                    Engineering</a>
                            </h3>
                            <p class="services-one__text">We design and implement fibre optic networks for communities of all sizes — from greenfield developments to brownfield upgrades. Our expertise covers outside plant routing, network optimisation, and reliable end-to-end connectivity.</p>
                            <!--<div class="services-one__arrow">-->
                            <!--    <a href="services.html"><span class="icon-right-arrow"></span></a>-->
                            <!--</div>-->
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 wow fadeInDown" data-wow-duration="1500ms" data-wow-delay="100ms">
                    <!--Services One Single-->
                    <div class="services-one__single">
                        <div class="services-one__img">
                            <img src="{{ asset('/images/piping and instru 2.webp') }}" alt="">
                            <div class="services-one__icon">
                                <span class="icon-petroleum"></span>
                            </div>
                        </div>
                        <div class="services-one__content">
                            <h3 class="services-one__title"><a href="petrolium-gas.html">Mechanical / Piping
                                    Engineering</a>
                            </h3>
                            <p class="services-one__text">From oil and gas pipelines to complex industrial facilities, our mechanical and piping engineers handle every phase — concept design, route planning, 2D and 3D drafting, and detailed engineering — with precision and safety at the core of every project.</p>
                            <!--<div class="services-one__arrow">-->
                            <!--    <a href="services.html"><span class="icon-right-arrow"></span></a>-->
                            <!--</div>-->
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 wow fadeInRight" data-wow-duration="1500ms" data-wow-delay="200ms">
                    <!--Services One Single-->
                    <div class="services-one__single">
                        <div class="services-one__img">
                            <img src="{{ asset('/images/eletrical 1.webp') }}" alt="">
                            <div class="services-one__icon">
                                <span class="icon-engineering"></span>
                            </div>
                        </div>
                        <div class="services-one__content">
                            <h3 class="services-one__title"><a href="mechanical-engineering.html">Electrical /
                                    Instrumentation</a></h3>
                            <p class="services-one__text">Our electrical and instrumentation teams deliver detailed design and documentation, including single-line diagrams, schematic layouts, termination and panel drawings, cable routing, load schedules, and bills of materials — ensuring accuracy, compliance, and efficiency across every installation.</p>
                            <!--<div class="services-one__arrow">-->
                            <!--    <a href="services.html"><span class="icon-right-arrow"></span></a>-->
                            <!--</div>-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Services One End-->

    <!--Tabs Box One Start-->
    <!--   <section class="tabs-box-one">
                                <div class="container">
                                    <div class="tabs-box-one__main-tab-box tabs-box">
                                        <ul class="tab-buttons clearfix list-unstyled">
                                            <li data-tab="#powerful" class="tab-btn "><span>Powerfull Strategy</span></li>
                                            <li data-tab="#leading" class="tab-btn active-btn"><span>Leading Industry</span></li>
                                            <li data-tab="#solutions" class="tab-btn"><span>Industry Solutions</span></li>
                                        </ul>
                                        <div class="tabs-content">

                                            <div class="tab " id="powerful">
                                                <div class="tabs-content__inner">
                                                    <div class="row">
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="tabs-content__inner-left">
                                                                <div class="tabs-content__inner-img">
                                                                    <img src="{{-- asset('/images/resources/tabs-content-inner-img-2.jpg') --}}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="tabs-content__inner-right">
                                                                <p class="tabs-content__inner-right-text">The majority have suffered
                                                                    alteration in some form humour or words which don't look even
                                                                    believable. If you are going to use a of you need to be sure there isn't
                                                                    anything.</p>
                                                                <ul class="list-unstyled tabs-content__inner-list">
                                                                    <li>
                                                                        <div class="icon">
                                                                            <span class="icon-factory"></span>
                                                                        </div>
                                                                        <div class="text">
                                                                            <h4>We’re Building Better Products</h4>
                                                                            <p>We understands that customer satisfaction starts with
                                                                                arriving at your location on time</p>
                                                                        </div>
                                                                    </li>
                                                                    <li>
                                                                        <div class="icon">
                                                                            <span class="icon-customer-review"></span>
                                                                        </div>
                                                                        <div class="text">
                                                                            <h4>Effective Industrial Team Work</h4>
                                                                            <p>We understands that customer satisfaction starts with
                                                                                arriving at your location on time</p>
                                                                        </div>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                       
                                            <div class="tab active-tab" id="leading">
                                                <div class="tabs-content__inner">
                                                    <div class="row flex-row-reverse">
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="tabs-content__inner-left">
                                                                <div class="tabs-content__inner-img">
                                                                    <img src="{{-- asset('/images/resources/tabs-content-inner-img.jpg') --}}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="tabs-content__inner-right">
                                                                <p class="tabs-content__inner-right-text">The majority have suffered
                                                                    alteration in some form humour or words which don't look even
                                                                    believable. If you are going to use a of you need to be sure there isn't
                                                                    anything.</p>
                                                                <ul class="list-unstyled tabs-content__inner-list">
                                                                    <li>
                                                                        <div class="icon">
                                                                            <span class="icon-factory"></span>
                                                                        </div>
                                                                        <div class="text">
                                                                            <h4>We’re Building Better Products</h4>
                                                                            <p>We understands that customer satisfaction starts with
                                                                                arriving at your location on time</p>
                                                                        </div>
                                                                    </li>
                                                                    <li>
                                                                        <div class="icon">
                                                                            <span class="icon-customer-review"></span>
                                                                        </div>
                                                                        <div class="text">
                                                                            <h4>Effective Industrial Team Work</h4>
                                                                            <p>We understands that customer satisfaction starts with
                                                                                arriving at your location on time</p>
                                                                        </div>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab " id="solutions">
                                                <div class="tabs-content__inner">
                                                    <div class="row">
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="tabs-content__inner-left">
                                                                <div class="tabs-content__inner-img">
                                                                    <img src="{{-- asset('/images/resources/tabs-content-inner-img-3.jpg') --}}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-6 col-lg-6">
                                                            <div class="tabs-content__inner-right">
                                                                <p class="tabs-content__inner-right-text">The majority have suffered
                                                                    alteration in some form humour or words which don't look even
                                                                    believable. If you are going to use a of you need to be sure there isn't
                                                                    anything.</p>
                                                                <ul class="list-unstyled tabs-content__inner-list">
                                                                    <li>
                                                                        <div class="icon">
                                                                            <span class="icon-factory"></span>
                                                                        </div>
                                                                        <div class="text">
                                                                            <h4>We’re Building Better Products</h4>
                                                                            <p>We understands that customer satisfaction starts with
                                                                                arriving at your location on time</p>
                                                                        </div>
                                                                    </li>
                                                                    <li>
                                                                        <div class="icon">
                                                                            <span class="icon-customer-review"></span>
                                                                        </div>
                                                                        <div class="text">
                                                                            <h4>Effective Industrial Team Work</h4>
                                                                            <p>We understands that customer satisfaction starts with
                                                                                arriving at your location on time</p>
                                                                        </div>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section> -->
    <!--Tabs Box One End-->

    <!--Brand One Start-->
    <section class="brand-one">
        <div class="container">
            <div class="thm-swiper__slider swiper-container"
                data-swiper-options='{"spaceBetween": 100, "slidesPerView": 5, "autoplay": { "delay": 5000 }, "breakpoints": {
            "0": {
                "spaceBetween": 30,
                "slidesPerView": 2
            },
            "375": {
                "spaceBetween": 30,
                "slidesPerView": 2
            },
            "575": {
                "spaceBetween": 30,
                "slidesPerView": 3
            },
            "767": {
                "spaceBetween": 50,
                "slidesPerView": 4
            },
            "991": {
                "spaceBetween": 50,
                "slidesPerView": 5
            },
            "1199": {
                "spaceBetween": 100,
                "slidesPerView": 5
            }
        }}'>
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-1.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-2.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-3.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-4.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-5.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-6.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-7.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-8.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                    <div class="swiper-slide">
                        <img src="{{ asset('/images/brand/brand-1-9.png') }}" alt="">
                    </div><!-- /.swiper-slide -->
                </div>
            </div>
        </div>
    </section>
    <!--Brand One End-->

    <!--We Building Start-->
    {{-- <section class="we-building">
    <div class="we-building-bg jarallax" data-jarallax data-speed="0.2" data-imgPosition="50% 0%"
        style="background-image: url({{asset('/images/backgrounds/we-building-bg.jpg')}})"></div>
<div class="container">
    <div class="row">
        <div class="col-xl-7 col-lg-7">
            <div class="we-building__video-box">
                <div class="we-building__video-link">
                    <a href="https://youtu.be/8ObUH-4uUlU" class="video-popup">
                        <div class="we-building__video-icon">
                            <span class="icon-play-button"></span>
                            <i class="ripple"></i>
                        </div>
                    </a>
                </div>
                <h2 class="we-building__video-title">We’re Building the Future and Restoring the Past</h2>
            </div>
        </div>
        <div class="col-xl-5 col-lg-5 wow slideInRight" data-wow-delay="100ms" data-wow-duration="2500ms">
            <div class="we-building__get-quote">
                <h2 class="we-building__get-quote-title">Get a Free Quote</h2>
                <form action="index.html" method="post" class="we-building__form">
                    <input type="text" placeholder="Your Name" name="name">
                    <input type="email" placeholder="Email Address" name="email">
                    <input type="text" placeholder="Phone Number" name="phone">
                    <button type="submit" class="btn-style-one we-building__get-quote-btn">
                        <i class="btn-curve"></i>
                        <span class="btn-title">Request a Quote</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
</section> --}}
    <!--We Building End-->

    <!--Projects One Start-->
    {{-- <section class="project-one">
    <div class="container">
        <div class="section-title text-center">
            <span class="section-title__tagline">Complete work list</span>
            <h2 class="section-title__title">Electrical Projects</h2>
        </div>
        <div class="project-one__carousel owl-theme owl-carousel">
            <!--Projects One Single-->
            <div class="project-one__single">
                <div class="project-one__img">
                    <img src="{{asset('/images/resources/project-one-img-1.jpg')}}" alt="">
<div class="project-one__content">
    <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5>
    <h3 class="project-one__tilte"><a href="project-details.html">Bridge Electrical</a>
    </h3>
    <div class="project-one__arrow">
        <a href="project-details.html"><span class="icon-right-arrow"></span></a>
    </div>
</div>
</div>
</div>
<!--Projects One Single-->
<div class="project-one__single">
    <div class="project-one__img">
        <img src="{{asset('/images/resources/project-one-img-2.jpg')}}" alt="">
        <div class="project-one__content">
            <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5>
            <h3 class="project-one__tilte"><a href="project-details.html">Bridge Electrical</a>
            </h3>
            <div class="project-one__arrow">
                <a href="project-details.html"><span class="icon-right-arrow"></span></a>
            </div>
        </div>
    </div>
</div>
<!--Projects One Single-->
<div class="project-one__single">
    <div class="project-one__img">
        <img src="{{asset('/images/resources/project-one-img-3.jpg')}}" alt="">
        <div class="project-one__content">
            <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5>
            <h3 class="project-one__tilte"><a href="project-details.html">Bridge Electrical</a>
            </h3>
            <div class="project-one__arrow">
                <a href="project-details.html"><span class="icon-right-arrow"></span></a>
            </div>
        </div>
    </div>
</div>
<!--Projects One Single-->
<div class="project-one__single">
    <div class="project-one__img">
        <img src="{{asset('/images/resources/project-one-img-4.jpg')}}" alt="">
        <div class="project-one__content">
            <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5>
            <h3 class="project-one__tilte"><a href="project-details.html">Bridge Electrical</a>
            </h3>
            <div class="project-one__arrow">
                <a href="project-details.html"><span class="icon-right-arrow"></span></a>
            </div>
        </div>
    </div>
</div>
<!--Projects One Single-->
<div class="project-one__single">
    <div class="project-one__img">
        <img src="{{asset('/images/resources/project-one-img-1.jpg')}}" alt="">
        <div class="project-one__content">
            <h5 class="project-one__tagline">Industrial <span>/</span> Factory</h5>
            <h3 class="project-one__tilte"><a href="project-details.html">Bridge Electrical</a>
            </h3>
            <div class="project-one__arrow">
                <a href="project-details.html"><span class="icon-right-arrow"></span></a>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</section> --}}
    <!--Projects One End-->





    <!--CTA One Start-->
    <section class="cta-one">
        <div class="cta-one-bg jarallax" data-jarallax data-speed="0.2" data-imgPosition="50% 0%"
            style="background-image: url({{ asset('/images/backgrounds/cta-one-bg.jpg') }})"></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="cta-one__inner wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                        <div class="cta-one__title">
                            <h2>World Class Quality,<br>Local talent,<br>Global Impact</h2>
                        </div>
                        <div class="cta-one__btn-box">
                            <a href="{{ url('our-company/about-quanta') }}" class="btn-style-one cta-one__btn">
                                <i class="btn-curve"></i>
                                <span class="btn-title">Discover </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
