@extends('layouts.admin.app')

@section('content')
	<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger white">
                    <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this data?
                </div>
                <div class="modal-footer">
                    <form method="post" action="{{ url('delete/1') }}" class="btn-ok"> @csrf @method('delete')
                    	<button type="submit" class="btn btn-danger">
                    	  	Yes
                    	</button>
                  	</form>
					<button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
	<div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                    	<a href="{{ url('home') }}">Home</a>
                                    </li>
                                    {{-- <li class="breadcrumb-item">
                                    	<a href="#">Data List</a>
                                    </li> --}}
                                    <li class="breadcrumb-item active">
                                    	Profile Settings
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            <div class="content-body">
                <div class="row">
                   
                    <div class="col-lg-6 ">
                        <div class="card border-info p-0">
                            <div class="card-header">
                                <h3 class="card-title">Update Information</h3>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="{{ url('Admin/Users/'.Auth::user()->id) }}" enctype="multipart/form-data">
                                    @csrf @method('put')
                                    <div class="form-group">
                                        <small>Full Name*</small>
                                        <input type="text" name="name" class="form-control" value="{{ Auth::user()->name }}" placeholder="Full Name" required="">
                                    </div>
                                    <div class="form-group">
                                        <small>Email Address*</small>
                                        <input type="email" name="email" class="form-control" value="{{ Auth::user()->email }}" placeholder="Email Address" required="">
                                    </div>
                                    <div class="form-group">
                                        <small>Role*</small>
                                        <input type="text" name="role" value="{{ Auth::user()->role }}" readonly="" required="" class="form-control">
                                    </div>
                                    <div class="form-group text-center">
                                        <button class="btn btn-primary" type="submit">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="card border-info p-0">
                            <div class="card-header">
                                <h3 class="card-title">Update Password</h3>
                            </div>
                            <div class="card-body box-profile">
                                <form method="post" class="" action="{{ url('Admin/Users/password/'.Auth::user()->id) }}" enctype="multipart/form-data">
                                    @csrf @method('put')
                                    @php 
                                        $name = explode('/', Auth::user()->name);
                                    @endphp
                                    <div class="form-group">
                                        <small>Old Password</small>
                                        <input id="password" type="password" placeholder="Old Password" class="form-control @error('password') is-invalid @enderror" name="oldpassword" required autocomplete="new-password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <small>New Password</small>
                                        <input id="password" type="password" placeholder="New Password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <small>Confirm New Password</small>
                                        <input id="password-confirm" type="password" placeholder="Confirm Password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                                    </div>
                                    <div class="form-group text-center">
                                        <button class="btn btn-primary" type="submit">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	
@stop
@section('js')
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
    {{-- <script src="{{ asset('js/filereader.min.js') }}"></script> --}}
	<script type="text/javascript">
        $('.delte').click(function () {
			var id = $(this).data('href');
			$('.btn-ok').attr('action', id);
			$('#deleteModal').modal('show');
		});
	</script>
@stop