@extends('layouts.admin.app')

@section('content')
	<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger white">
                    <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this data?
                </div>
                <div class="modal-footer">
                    <form method="post" action="{{ url('delete/1') }}" class="btn-ok"> @csrf @method('delete')
                    	<button type="submit" class="btn btn-danger">
                    	  	Yes
                    	</button>
                  	</form>
					<button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
	<div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                    	<a href="{{ url('home') }}">Home</a>
                                    </li>
                                    {{-- <li class="breadcrumb-item">
                                    	<a href="#">Data List</a>
                                    </li> --}}
                                    <li class="breadcrumb-item active">
                                    	Users
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            
            <div class="content-body">
                <!-- Data list view starts -->
                <section id="data-list-view" class="data-list-view-header">
                    @if(Auth::user()->role != 'viewer')
                	<div class="">
                		<button type="button" class="btn btn-primary mr-1 mb-1 waves-effect waves-light" data-toggle="modal" data-target="#default">Add User</button>
                	</div>
                    @endif
                	@include('module.user.create')
                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <table class="table table-striped zero-configuration {{-- dataex-html5-selectors --}} table-hover-animation">
                            <thead>
                                <tr>
                                    <th>FULLNAME</th>
                                    <th>EMAIL</th>
                                    <th>ROLE</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                            	@foreach($data as $value)
                                <tr class="text-center">
                                	{{-- <td>{{ $count++ }}</td> --}}
                                	<td>{{ str_replace(',', ' ', $value->name) }}</td>
                                	<td>
                                		{!! $value->email !!}
                                	</td>
                                    <td>
                                        {{ ucfirst($value->role) }}
                                    </td>
                                	<td>
                                        @if(Auth::user()->id == $value->id)
                                            {{-- <small class="font-italic">No Action</small> --}}
                                        <a class="text-italic" href="{{ url('Admin/Profile') }}">
                                            <u>View Profile</u>
                                        </a>
                                        @else 
                                            @if($value->role == 'customer')
                                                <small class="font-italic">No Action</small>
                                            @elseif(Auth::user()->role == 'editor' || Auth::user()->role == 'admin')
                                            <div class="row justify-content-center">
                                        		<a class="mr-1" href="#" data-toggle="modal" data-target="#update{{ $value->id }}">
                                        			{{-- <i data-feather="edit"></i> --}}
                                                    Edit
                                        		</a>
                                                |
                                                <form method="post" class="ml-1" action="{{ url('Admin/Account/activation/'.$value->id) }}">
                                                    @csrf
                                                    @if($value->activation == 1)
                                                    <input type="text" name="activation" value="0" hidden="">
                                                    <button class="btn p-0 text-danger">
                                                        Deactivate
                                                    </button>
                                                    @else
                                                    <input type="text" name="activation" value="1" hidden="">
                                                    <button class="btn p-0 text-danger">
                                                        Activate
                                                    </button>
                                                    @endif
                                                    
                                                </form>
                                            </div>
                                    		<!-- <a class="delte text-danger" href="#" data-href="{{ url('Admin/Users/'.$value->id) }}" id="deletecart">
                                                Deactivate
    					                	</a> -->
                                            @else 
                                            <small class="font-italic">No Action</small>
                                            @endif
                                        @endif
                                	</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </div>
	@foreach($data as $value)
    @include('module.user.update')
    @endforeach
@stop
@section('js')
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
    {{-- <script src="{{ asset('js/filereader.min.js') }}"></script> --}}
	<script type="text/javascript">
        $('.delte').click(function () {
			var id = $(this).data('href');
			$('.btn-ok').attr('action', id);
			$('#deleteModal').modal('show');
		});
	</script>
@stop