
<?php $__env->startSection('content'); ?>
<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header bg-danger white">
                <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this data?
            </div>
            <div class="modal-footer">
                <form method="post" action="<?php echo e(url('delete/1')); ?>" class="btn-ok"> <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                    <button type="submit" class="btn btn-danger">
                        Yes
                    </button>
                </form>
                <button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
            </div>
        </div>
    </div>
</div>
<div class="app-content content" id="table-hover-animation">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs">
                    <div class="col-12">
                        <h2 class="content-header-title float-left mb-0">List View</h2>
                        <div class="breadcrumb-wrapper col-12">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(url('admin/dashboard')); ?>">Home</a>
                                </li>
                                
                                <li class="breadcrumb-item active">
                                    Applicants
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <a href="<?php echo e(route('applicants.export')); ?>" class="btn btn-success mb-2">Export to Excel</a>

        <div class="content-body">
            <!-- Data list view starts -->
            <section id="data-list-view" class="data-list-view-header">
                <!-- DataTable starts -->
                <div class="table-responsive">
                    <table class="table table-striped zero-configuration  table-hover-animation">
                        <thead>
                            <tr>
                                
                                <th>JOB TITLE</th>
                                <th>NAME</th>
                                <th>CONTACT NUMBER</th>
                                <th>EMAIL</th>
                                <th>ADDRESS</th>
                                <th>RESUME</th>
                                <th>ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="text-center">
                                
                                <td>
                                    <?php echo e($value->career->title); ?>

                                </td>
                                <td>
                                    <?php echo e($value->name); ?>

                                </td>
                                <td>
                                    <?php echo e($value->contact_number); ?>

                                </td>
                                <td>
                                    <?php echo e($value->email); ?>

                                </td>
                                <td>
                                    <?php echo e($value->address); ?>

                                </td>
                                <td>

                                    <a href="<?php echo e(asset($value->resume)); ?>" target="_blank" class="text-blue-500">View Resume</a>
                                </td>
                                <td>
                                    <?php if(Auth::user()->role != 'viewer'): ?>
                                    <a class="delte text-danger" data-href="<?php echo e(url('admin/applicants/'.$value->id)); ?>" id="deletecart">
                                        Delete
                                    </a>
                                    <?php else: ?>
                                    <small class="font-italic">No Action</small>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </section>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
<script>
</script>
<script>
    // CKEDITOR.replace('message');
    $(function() {
        // $("#example1").DataTable();
        $('#example1').DataTable({
            "paging": true,
            "pageLength": 50,
            "lengthChange": true,
            "searching": true,
            "ordering": false,
            "info": true,
            "autoWidth": false,
        });
        $('.select2').select2();
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        });
    });
    $('.delte').click(function() {
        var id = $(this).data('href');
        $('.btn-ok').attr('action', id);
        $('#deleteModal').modal('show');
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Markeh\Websites\quanta (10-01-2025)\well-known (6)\resources\views/module/applicants/index.blade.php ENDPATH**/ ?>