<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="author" content="Serbilis.ph">
    <title><?php echo e(ucfirst(Auth::user()->role)); ?> | <?php echo e(env('APP_NAME')); ?></title>
    <link rel="apple-touch-icon" href="<?php echo e(asset('images/favicon.ico')); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.ico')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/admin.min.css')); ?>">
    
    <!-- END: Vendor CSS-->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- END: Custom CSS-->
</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern 2-columns  navbar-floating footer-static  " data-open="click" data-menu="vertical-menu-modern" data-col="2-columns">

    <!-- BEGIN: Header-->
    <nav class="header-navbar navbar-expand-lg navbar navbar-with-menu floating-nav navbar-light navbar-shadow">
        <div class="navbar-wrapper">
            <div class="navbar-container content">
                <div class="navbar-collapse" id="navbar-mobile">
                    <div class="mr-auto float-left bookmark-wrapper d-flex align-items-center">
                        <ul class="nav navbar-nav">
                            <li class="nav-item mobile-menu d-xl-none mr-auto">
                                <a class="nav-link nav-menu-main menu-toggle hidden-xs" href="#">
                                    <i data-feather="menu"></i>
                                
                                </a>
                            </li>
                        </ul>
                        <ul class="nav navbar-nav bookmark-icons">
                            <!-- li.nav-item.mobile-menu.d-xl-none.mr-auto-->
                            <!--   a.nav-link.nav-menu-main.menu-toggle.hidden-xs(href='#')-->
                            <!--     i.ficon.feather.icon-menu-->
                            
                        </ul>
                    </div>
                    <ul class="nav navbar-nav float-right">
                        
                        <li class="nav-item d-none d-lg-block">
                            <a class="nav-link nav-link-expand">
                                <i data-feather="maximize"></i>
                                
                            </a>
                        </li>
                        
                        <li class="dropdown dropdown-user nav-item">
                            <a class="dropdown-toggle nav-link dropdown-user-link" href="#" data-toggle="dropdown">
                                <div class="user-nav d-sm-flex d-none">
                                    <span class="user-name text-bold-600"><?php echo e(Auth::user()->name); ?></span>
                                    <span class="user-status">Available</span>
                                </div>
                                <span>
                                    <img class="round" src="<?php echo e(asset('images/avatar.jpg')); ?>" alt="avatar" height="40" width="40">
                                </span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right">
                                
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i data-feather="power"></i>
                                    Logout
                                </a>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!-- END: Header-->


    <!-- BEGIN: Main Menu-->
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item mr-auto">
                    <a class="navbar-brand" href="<?php echo e(url('home')); ?>">
                        <img src="<?php echo e(asset('images/fibre-transparent.png')); ?>" class="img-fluid" width="45px">
                        
                        <h6 class="brand-title mb-0 ml-1">DFPPI</h6>
                    </a>
                </li>
                <li class="nav-item nav-toggle">
                    <a class="nav-link modern-nav-toggle pr-0" data-toggle="collapse">
                        <i data-feather="x" class=" d-block d-xl-none font-medium-4 primary toggle-icon"></i>
                        <i data-feather="disc" class="toggle-icon font-medium-4 d-none d-xl-block collapse-toggle-icon primary" data-ticon="icon-disc"></i>
                        
                        
                    </a>
                </li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <div class="main-menu-content">
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class=" nav-item">
                    <a href="<?php echo e(url('home')); ?>">
                        <i data-feather="home"></i>
                        
                        <span class="menu-title" data-i18n="Dashboard">Dashboard</span>
                    </a>
                </li>
                <li class=" nav-item <?php echo e(Request::is('Admin/Corrugated-box') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Corrugated-box')); ?>" class="">
                        <i data-feather="package" class=""></i>
                        <span class="menu-title" data-i18n="User">Corrugated-box</span>
                    </a>
                </li>
                <li class=" nav-item <?php echo e(Request::is('Admin/Contacts') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Contacts')); ?>" class="">
                        <i data-feather="user-plus" class=""></i>
                        <span class="menu-title" data-i18n="User">Contacts</span>
                    </a>
                </li>
                <li class=" nav-item <?php echo e(Request::is('Admin/Newsletters') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Newsletters')); ?>" class="">
                        
                        <i class="far fa-envelope"></i>
                        <span class="menu-title" data-i18n="User">Newsletter</span>
                    </a>
                </li>
                <li class=" nav-item <?php echo e(Request::is('Admin/Partners') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Partners')); ?>" class="">
                        
                        <i class="fas fa-user-tie"></i>
                        <span class="menu-title" data-i18n="User">Partners</span>
                    </a>
                </li>
                
                
                <li class=" nav-item <?php echo e(Request::is('Admin/User-Comments') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/User-Comments')); ?>" class="">
                        <i data-feather="message-square" class=""></i>
                        <span class="menu-title" data-i18n="User">User-Comments</span>
                    </a>
                </li>
                
                <li class=" nav-item <?php echo e(Request::is('Admin/Events') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Events')); ?>" class="">
                        <i data-feather="user" class=""></i>
                        <span class="menu-title" data-i18n="User">News and Events</span>
                    </a>
                </li>
                <li class=" nav-item <?php echo e(Request::is('Admin/Testimonials') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Testimonials')); ?>" class="">
                        <i data-feather="message-square" class=""></i>
                        <span class="menu-title" data-i18n="User">Testimonials</span>
                    </a>
                </li>
                <li class=" nav-item <?php echo e(Request::is('Admin/Products') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Products')); ?>" class="">
                        <i data-feather="message-square" class=""></i>
                        <span class="menu-title" data-i18n="User">Products</span>
                    </a>
                </li>
                <!-- <li class=" nav-item <?php echo e(Request::is('Admin/team-members') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/team-members')); ?>" class="">
                        <i class="fas fa-user-tie"></i>
                        <span class="menu-title" data-i18n="User">Team Members</span>
                    </a>
                </li> -->
                <!-- <li class=" nav-item <?php echo e(Request::is('Admin/faqs') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/faqs')); ?>" class="">
                        <i class="fas fa-info-circle"></i>
                        <span class="menu-title" data-i18n="User">FAQs</span>
                    </a>
                </li> -->
                
                
                <?php if(Auth::user()->id == 1): ?>
                <li class=" nav-item <?php echo e(Request::is('Admin/Users') ? 'active' : null); ?>">
                    <a href="<?php echo e(url('Admin/Users')); ?>" class="">
                        <i data-feather="users" class=""></i>
                        <span class="menu-title" data-i18n="User">Users</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if(Auth::user()->id != 1): ?>
                <li class=" navigation-header">
                    <span>Dashboard</span>
                </li>
                <li class=" nav-item">
                    <a href="<?php echo e(url('Admin/Profile')); ?>">
                        <i data-feather="user"></i>
                        <span class="menu-title" data-i18n="Profile">Profile Settings</span>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    <?php echo $__env->yieldContent('content'); ?>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        <p class="clearfix blue-grey lighten-2 mb-0">
            <span class="float-md-left d-block d-md-inline-block mt-25">COPYRIGHT &copy; <?php echo e(date('Y')); ?>

                <a class="text-bold-800 grey darken-2" href="" target="_blank"><?php echo e(env('APP_NAME')); ?>,</a>
                All rights Reserved
            </span>
            <span class="float-md-right d-none d-md-block">
                R Web Solutions Corp.
                <i data-feather="heart" class="pink"></i>
                
            </span>
            <button class="btn btn-primary btn-icon scroll-top" type="button">
                <i data-feather="arrow-up"></i>
                
            </button>
        </p>
    </footer>
    <!-- END: Footer-->


    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(asset('js/admin.min.js')); ?>"></script>
    
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
    <script type="text/javascript">
        feather.replace({ class: 'foobar'});
        
    </script>
    <?php echo $__env->yieldContent('js'); ?>
</body>
<!-- END: Body-->

</html><?php /**PATH /home/rwsserver/public_html/davaofiberboard/resources/views/layouts/admin/app.blade.php ENDPATH**/ ?>