
<?php $__env->startSection('meta'); ?>
	<title>Payment | <?php echo e(env('APP_NAME')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<style>
    @import  url('https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap');
    @import  url('https://fonts.googleapis.com/css2?family=Montserrat&display=swap');
    body{
        background: rgb(255,204,204);
        background: linear-gradient(0deg, rgb(242 221 207) 14%, rgb(242 221 207) 100%);
    }
    .empire h1{
        color: #663333;
        font-family: 'Bebas Neue', cursive;
    }
    .empire p{
        font-weight: 600;
        color: #663333;
        font-size: 15px;
        text-align: justify;
    }
    .empire li, p, button{
        font-family: 'Montserrat', sans-serif;
    }
    .empire li{
        display: flex;
        margin-bottom: 10px;
    }
    .empire li img{
        height: 40px;
        width: 40px;
        margin-right: 20px;
    }
    @media (max-width: 1199.98px){

    }
    @media (max-width: 991.98px){

    }
    @media (max-width: 575.98px){
        .empire li img{
            height: 30px;
            width: 30px;
        }
        .empire button{
            padding: 10px 20px !important;
        }
    }
    @media (max-width: 375.98px){
        .empire li img{
            height: 25px;
            width: 25x;
        }
    }
    .bg-primary{
        background: linear-gradient(0deg, rgb(242 221 207) 14%, rgb(242 221 207) 100%) !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="empire">
    <img class="position-absolute" style="height: 70vh; width: 100%; z-index: -1;" src="<?php echo e(asset('images/bg.png')); ?>" alt="">
    <form class="needs-validation" action="<?php echo e(url('order')); ?>" method="get"> <?php echo csrf_field(); ?>
    <div class="container py-5 pt-5">
        <div class="row mt-5 py-5 g-0 justify-content-center shadow-lg rounded-3">
            <div class="col-lg-7 p-5 bg-primary">
                <h3>Payment Details</h3>
                <div class="col-md-12 mb-3">
                    <label for="validationCustom01" class="form-label">Full Name</label>
                    <input type="text" class="form-control bill_name" id="validationCustom01" name="bill_name" value="<?php echo e(old('bill_name')); ?>" required>
                </div>
                <div class="col-md-12 mb-3">
                    <label for="validationCustom02" class="form-label">Phone No.</label>
                    <input type="text" class="form-control bill_phone" id="validationCustom02" name="bill_phone" value="<?php echo e(old('bill_phone')); ?>" required>
                </div>
                <div class="col-md-12 mb-3">
                    <label for="validationCustomUsername" class="form-label">Email</label>
                    <div class="input-group">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="fa fa-envelope" aria-hidden="true"></i></i></span>
                    <input type="text" class="form-control bill_email" id="validationCustomUsername" name="bill_email" value="<?php echo e(old('bill_email')); ?>" aria-describedby="inputGroupPrepend" required>
                    </div>
                </div>
                <div class="col-md-12 mb-3">
                    <label for="validationCustom03" class="form-label">Full Address</label>
                    <input type="text" class="form-control bill_address" id="validationCustom03" name="bill_address" value="<?php echo e(old('bill_address')); ?>" required>
                </div>
                
                
                <div class="col-12">
                    <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="terms" <?php echo e(old('terms') == 'on' ? 'checked' : null); ?> id="invalidCheck" required>
                    <label class="form-check-label" for="invalidCheck">
                        Agree to terms and conditions
                    </label>
                    <div class="invalid-feedback">
                        You must agree before submitting.
                    </div>
                    </div>
                </div>
              
            </div>
            <div class="col-lg-3">
                <?php
                    $order = (object) session('order');
                ?>
                <div class="needs-validation p-5 bg-primary">
                    <h3>Order Details</h3>
                    <h5>Product name: <?php echo e($product->name); ?></h5>
                    <h5>Product Price: <?php echo e($product->price); ?></h5>
                    <h5>Qty: <?php echo e($order->qty); ?></h5>
                    <h5>Total: $<span id="paypalAmount"><?php echo e($order->qty * $product->price); ?></span> </h5>
                    
                </div>
            </div>
            <div class="col-12 text-center">
                <button class="btn btn-md cs-bg-secondary text-white" type="submit">Proceed</button>
            </div>
        </div>
    </div>
</form>
</div>

<?php if(Session::has('pay')): ?>
<div class="modal fade" id="modal-pay" tabindex="-1" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header text-right ml-auto pr-0">
                <button type="button" class="btn btn_brown rounded-circle" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div id="paypal-button-container"></div>
                <?php echo e(Session::forget('pay')); ?>

            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
 
<!-- Include the PayPal JavaScript SDK -->

<script src="https://www.paypal.com/sdk/js?client-id=<?php echo e(config('services.paypal.client_id')); ?>&currency=USD"></script>

<script>
    $(window).on('load', function() {
        $('#modal-pay').modal('show');
    });
    // Render the PayPal button into #paypal-button-container
    paypal.Buttons({
// Call your server to set up the transaction
         createOrder: function(data, actions) {
            return fetch('/api/paypal/order/create', {
                method: 'POST',
                body:JSON.stringify({
                    'product_id': "<?php echo e($product->id); ?>",
                    // 'user_id' : "<?php echo e(auth()->user()->id); ?>",
                    'amount' : <?php echo e($order->qty * $product->price); ?>,
                })
            }).then(function(res) {
                //res.json();
                // console.log(res.json())
                return res.json();
            }).then(function(orderData) {
                console.log(orderData);
                return orderData.id;
            });
        },

        // Call your server to finalize the transaction
        onApprove: function(data, actions) {
            return fetch('/api/paypal/order/capture' , {
                method: 'POST',
                body :JSON.stringify({
                    orderId : data.orderID,
                    product_id : <?php echo e($product->price); ?>,
                    total_amount_due : <?php echo e($order->qty * $product->price); ?>,
                    // user_id: "<?php echo e(auth()->user()->id); ?>",
                })
            }).then(function(res) {
               // console.log(res.json());
                return res.json();
            }).then(function(orderData) {

                // Successful capture! For demo purposes:
              //  console.log('Capture result', orderData, JSON.stringify(orderData, null, 2));
                var transaction = orderData.purchase_units[0].payments.captures[0];
                iziToast.success({
                    title: 'Success',
                    message: 'Payment completed',
                    position: 'topRight'
                });
            });
        }

    }).render('#paypal-button-container');
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\PC4\Desktop\leo dev\thedreway dev\thedreway\resources\views/front/payment.blade.php ENDPATH**/ ?>