
<?php $__env->startSection('meta'); ?>
	<title>Payment | <?php echo e(env('APP_NAME')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<style>
    @import  url('https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap');
    @import  url('https://fonts.googleapis.com/css2?family=Montserrat&display=swap');
    body{
        background: rgb(255,204,204);
        background: linear-gradient(0deg, rgb(242 221 207) 14%, rgb(242 221 207) 100%);
    }
    .empire h1{
        color: #663333;
        font-family: 'Bebas Neue', cursive;
    }
    .empire p{
        font-weight: 600;
        color: #663333;
        font-size: 15px;
        text-align: justify;
    }
    .empire li, p, button{
        font-family: 'Montserrat', sans-serif;
    }
    .empire li{
        display: flex;
        margin-bottom: 10px;
    }
    .empire li img{
        height: 40px;
        width: 40px;
        margin-right: 20px;
    }
    @media (max-width: 1199.98px){

    }
    @media (max-width: 991.98px){

    }
    @media (max-width: 575.98px){
        .empire li img{
            height: 30px;
            width: 30px;
        }
        .empire button{
            padding: 10px 20px !important;
        }
    }
    @media (max-width: 375.98px){
        .empire li img{
            height: 25px;
            width: 25x;
        }
    }
    .bg-primary{
        background: linear-gradient(0deg, rgb(242 221 207) 14%, rgb(242 221 207) 100%) !important;
    }
    .empire button{
        padding: 15px 15px !important;
        font-size: 12px;
        color: #ffffff;
        background-color: #312626;
    }
    .empire button.paypal{
        background-color: #1a3547f2;
    }
    .empire button{
        padding: 15px 15px !important;
        font-size: 12px;
        color: #ffffff;
        background-color: #312626;
    }
    .StripeElement {
        box-sizing: border-box;
        height: 40px;
        padding: 10px 12px;
        border: 1px solid transparent;
        border-radius: 4px;
        background-color: white;
        box-shadow: 0 1px 3px 0 #e6ebf1;
        -webkit-transition: box-shadow 150ms ease;
        transition: box-shadow 150ms ease;
    }
    .StripeElement--focus {
        box-shadow: 0 1px 3px 0 #cfd7df;
    }
    .StripeElement--invalid {
        border-color: #fa755a;
    }
    .StripeElement--webkit-autofill {
        background-color: #fefde5 !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="empire">
    <img class="position-absolute" style="height: 70vh; width: 100%; z-index: -1;" src="<?php echo e(asset('images/bg.png')); ?>" alt="">
    <div class="container py-5 pt-5">
        <div class="row mt-5 py-5 g-0 justify-content-center shadow-lg rounded-3">
            <div class="col-lg-7 p-5 bg-primary">

                <h3>Select Payment</h3>
                <div class="col-12 text-center">
                    <div class="text-cente d-flex align-items-center">
                        <form class="needs-validation" action="<?php echo e(route('paypal')); ?>" method="post"> <?php echo csrf_field(); ?>

                            <input hidden type="text" name="bill_phone" value="<?php echo e(session('bill_details')['bill_phone']); ?>">
                            <button class="rounded-3 border-0 me-3 paypal"><i class="fa fa-paypal" aria-hidden="true"></i> PAY WITH PAYPAL</button>
                        </form>
                        or
                        

                            <button type="reset" class="rounded-3 border-0 ms-3 stripe" data-toggle="modal" data-target="#modal-stripe"><i class="fa-brands fa-stripe-s"></i> PAY WITH STRIPE</button>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-stripe" tabindex="-1" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header text-right ml-auto pr-0">
                <button type="button" class="btn btn_brown rounded-circle" data-dismiss="modal">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <h3>Stripe payment</h3>
                <form method="POST" action="<?php echo e(url('stripe-checkout')); ?>" class="card-form mt-3 mb-3">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                    <input type="hidden" name="payment_method" class="payment-method">
                    <input class="StripeElement mb-3 w-100" name="card_holder_name" placeholder="Card holder name" required>
                    <div class="">
                        <div id="card-element"></div>
                    </div>
                    <div id="card-errors" class="text-danger" role="alert"></div>
                    <div class="form-group mt-3 text-center">
                        <button type="submit" class="btn stripe text-white pay border bg-black">
                            Purchase
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        // stripe
        let stripe = Stripe("<?php echo e(env('STRIPE_KEY')); ?>")
        let elements = stripe.elements()
        let style = {
            base: {
                color: '#32325d',
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                    color: '#aab7c4'
                }
            },
            invalid: {
                color: '#fa755a',
                iconColor: '#fa755a'
            }
        }
        let card = elements.create('card', {style: style})
        card.mount('#card-element')
        let paymentMethod = null
        $('.card-form').on('submit', function (e) {
            $('button.pay').attr('disabled', true)
            if (paymentMethod) {
                return true
            }
            stripe.confirmCardSetup(
                "<?php echo e($intent->client_secret); ?>",
                {
                    payment_method: {
                        card: card,
                        billing_details: {name: $('.card_holder_name').val()}
                    }
                }
            ).then(function (result) {
                if (result.error) {
                    $('#card-errors').text(result.error.message)
                    $('button.pay').removeAttr('disabled')
                } else {
                    paymentMethod = result.setupIntent.payment_method
                    $('.payment-method').val(paymentMethod)
                    $('.card-form').submit()
                }
            })
            return false
        })
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.front.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\PC4\Desktop\leo dev\thedreway dev\july 16 2022\thedreway\resources\views/front/select-payment.blade.php ENDPATH**/ ?>