
<?php $__env->startSection('content'); ?>
    <div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="<?php echo e(url('home')); ?>">Home</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="<?php echo e(url('Admin/News')); ?>">News</a>
                                    </li>
                                    <li class="breadcrumb-item active">
                                        Update
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
            <div class="content-body bg-white p-3">
                <form method="post" class="row" action="<?php echo e(url('Admin/News/'.$data->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?> <?php echo method_field('put'); ?>
                    <div class="form-group col-lg-12">
                        <small>Thumbnail Image Should be less than 1mb </small>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="image" id="file" accept=".png,.jpeg,.jpg" >
                                <label class="custom-file-label light_gray" for="exampleInputFile">UPLOAD ONE(1) IMAGE WITH DIMENSIONS (1200x700)</label>
                            </div>
                        </div>
                        <div id="alert-col">
                        </div>
                        <div class="gallery" id="gallery2">
                            <img src="<?php echo e(asset('uploads/news/'.$data->image)); ?>" class="img-fluid">
                        </div>
                    </div>
                    
                    <div class="form-group col-lg-12">
                        <small>Title*</small>
                        <input type="text" name="title" class="form-control" value="<?php echo e($data->title); ?>" placeholder="Title" required="">
                    </div>

                    <div class="form-group col-lg-12">
                        <small>Tags*</small>
                        <select class="form-control select2" name="tag_id[]" multiple="" required="">
                            <option></option>
                            <?php $__currentLoopData = App\Models\Tag::latest()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($tag->id); ?>" <?php if(in_array($tag->id, json_decode($data->tag_id))): ?> selected <?php endif; ?>><?php echo e($tag->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group col-lg-12">
                        <small>Description</small>
                        <textarea name="description" id="description" class="form-control" rows="5" required=""><?php echo $data->description; ?></textarea>
                    </div>
                    
                    <div class="form-group text-center col-lg-12">
                        <button class="btn btn-primary" type="submit" id="submit">ADD</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('js/filereader.min.js')); ?>"></script>
    <script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
    <script type="text/javascript">
        CKEDITOR.replace('description');
        var uploadField = document.getElementById("file");

        uploadField.onchange = function() {
          const fsize = this.files[0].size;
          const file = Math.round((fsize / 1048)); 
          if (file >= 1048) { 
            $('#file').addClass('is-invalid');
            document.getElementById('alert-col').innerHTML = '<small class="text-danger">File too Big, please select a file less than 1mb </small>';
            $('#submit').prop('disabled', true);
          }else{
            $('#file').removeClass('is-invalid');
            document.getElementById('alert-col').innerHTML = '';
            $('#submit').prop('disabled', false);
          }
        };

        var imagesPreview = function(input, placeToInsertImagePreview) {

            if (input.files) {
                var filesAmount = input.files.length;

                for (i = 0; i < filesAmount; i++) {
                    var reader = new FileReader();

                    reader.onload = function(event) {
                        $($.parseHTML('<img class="img-fluid">')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                    }

                    reader.readAsDataURL(input.files[i]);
                }
            }

        };


        $('#file').on('change', function() {
            $('#gallery2 img').remove();
            imagesPreview(this, 'div#gallery2');
        });

        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\fiberboard\resources\views/module/news/news/update.blade.php ENDPATH**/ ?>